/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Config;

import Proyecto.MegaWeb2.__BackEnd.Security.JwtAuthenticationFilter;
import Proyecto.MegaWeb2.__BackEnd.Security.JwtUtil;
import jakarta.servlet.Filter;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@Configuration
public class SecurityConfig {
    @Autowired
    private JwtUtil jwtUtil;

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration cfg = new CorsConfiguration();
        cfg.setAllowedOrigins(List.of("https://jade-muffin-c2e1f8.netlify.app"));
        cfg.setAllowedMethods(List.of("GET", "POST", "PUT", "DELETE", "OPTIONS"));
        cfg.setAllowedHeaders(List.of("*"));
        cfg.setAllowCredentials(Boolean.valueOf(true));
        UrlBasedCorsConfigurationSource src = new UrlBasedCorsConfigurationSource();
        src.registerCorsConfiguration("/**", cfg);
        return src;
    }

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        http.cors(cors -> {}).csrf(csrf -> csrf.disable()).sessionManagement(sm -> sm.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).authorizeHttpRequests(auth -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/auth/login"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/auth/verify-2fa"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/auth/forgot-password"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/auth/restablecer-password"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/api/auth/usuarios"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/auth/generate-qr/**"})).permitAll().requestMatchers(new String[]{"/estilos.css", "/javascript.js", "/img/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/test/enviar"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/publicaciones"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/nosotros"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/productos/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/busquedas/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/consultas/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/clientes/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/comentarios"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/api/productos/{id}"})).permitAll().anyRequest()).authenticated()).addFilterBefore((Filter)new JwtAuthenticationFilter(this.jwtUtil), UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)http.build();
    }
}

