/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.AdminRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.AdminUpdateRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.AdminService;
import Proyecto.MegaWeb2.__BackEnd.Service.AuditService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import Proyecto.MegaWeb2.__BackEnd.Util.URLEncryptionUtil;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SecurityRequirement(name="bearerAuth")
@RestController
@RequestMapping(value={"/api/administradores"})
public class AdminController {
    @Autowired
    private AdminService adminService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    @Autowired
    private AuditService auditService;
    private static final int ID_MODULO_ADMINISTRADORES = 1;

    private String obtenerIPCliente(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }

    @PostMapping
    public ResponseEntity<?> crearAdministrador(@RequestParam String nombres, @RequestParam String apellidos, @RequestParam String username, @RequestParam String password, @RequestParam String email, @RequestParam Integer rolNuevoAdministrador, HttpServletRequest request) {
        Integer idRolSesion = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        if (idRolSesion == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRolSesion.intValue(), 1, "pCreate")) {
            this.auditService.registrarDenegacionPermiso("ADMIN", "/api/administradores", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para crear administradores\"}");
        }
        AdminRequestDTO dto = new AdminRequestDTO();
        dto.setNombres(nombres);
        dto.setApellidos(apellidos);
        dto.setUsername(username);
        dto.setPassword(password);
        dto.setEmail(email);
        dto.setRol(rolNuevoAdministrador);
        int idGenerado = this.adminService.registrarAdministrador(dto);
        if (idGenerado > 0) {
            String idEncriptado = URLEncryptionUtil.encriptarId((Integer)idGenerado);
            this.auditService.registrarEvento("ADMIN", "CREAR_ADMINISTRADOR", "Admin creado: " + username, ipCliente, "/api/administradores", "POST");
            return ResponseEntity.ok().body((Object)("{\"idAdministrador\": \"" + idEncriptado + "\"}"));
        }
        return ResponseEntity.status((int)500).body((Object)"{\"error\": \"No se pudo crear el administrador\"}");
    }

    @GetMapping
    public ResponseEntity<?> listarAdministradores(HttpServletRequest request) {
        Integer idRolSesion = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        if (idRolSesion == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRolSesion.intValue(), 1, "pView")) {
            this.auditService.registrarDenegacionPermiso("ADMIN", "/api/administradores", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para ver administradores\"}");
        }
        List lista = this.adminService.listarAdministradores();
        this.auditService.registrarAccesoRecurso("ADMIN", "/api/administradores", ipCliente);
        return ResponseEntity.ok((Object)lista);
    }

    @PutMapping
    public ResponseEntity<?> actualizarAdministrador(@RequestParam String idEncriptado, @RequestParam String nombres, @RequestParam String apellidos, @RequestParam String username, @RequestParam String email, @RequestParam Integer rol, @RequestParam(required=false) String passwordActual, @RequestParam(required=false) String nuevaPassword, @RequestParam(required=false) String confirmarPassword, HttpServletRequest request) {
        Integer idRolSesion = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        if (idRolSesion == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRolSesion.intValue(), 1, "pUpdate")) {
            this.auditService.registrarDenegacionPermiso("ADMIN", "/api/administradores", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para editar administradores\"}");
        }
        try {
            Integer id = URLEncryptionUtil.desencriptarId((String)idEncriptado);
            if (id == null) {
                return ResponseEntity.status((int)400).body((Object)"{\"error\": \"ID inv\u00e1lido\"}");
            }
            AdminUpdateRequestDTO dto = new AdminUpdateRequestDTO();
            dto.setId(id.intValue());
            dto.setNombres(nombres);
            dto.setApellidos(apellidos);
            dto.setUsername(username);
            dto.setEmail(email);
            dto.setRol(rol);
            dto.setPasswordActual(passwordActual);
            dto.setNuevaPassword(nuevaPassword);
            dto.setConfirmarPassword(confirmarPassword);
            this.adminService.editarAdministrador(dto);
            this.auditService.registrarEvento("ADMIN", "ACTUALIZAR_ADMINISTRADOR", "Admin actualizado ID: " + id, ipCliente, "/api/administradores", "PUT");
            return ResponseEntity.ok((Object)"{\"mensaje\": \"Administrador actualizado correctamente\"}");
        }
        catch (Exception e) {
            return ResponseEntity.internalServerError().body((Object)("{\"error\": \"" + e.getMessage() + "\"}"));
        }
    }

    @PostMapping(value={"/eliminar/{idEncriptado}"})
    public ResponseEntity<?> eliminarAdministrador(@PathVariable String idEncriptado, HttpServletRequest request) {
        Integer idRolSesion = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        String usuarioAdmin = (String)request.getAttribute("username");
        if (idRolSesion == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRolSesion.intValue(), 1, "pDelete")) {
            this.auditService.registrarDenegacionPermiso(usuarioAdmin, "/api/administradores/eliminar", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para eliminar administradores\"}");
        }
        try {
            Integer id = URLEncryptionUtil.desencriptarId((String)idEncriptado);
            if (id == null) {
                return ResponseEntity.status((int)400).body((Object)"{\"error\": \"ID inv\u00e1lido\"}");
            }
            Integer idEliminado = this.adminService.eliminarUsuario(id);
            this.auditService.registrarEliminacion(usuarioAdmin, id, "ADMINISTRADOR", ipCliente);
            String idEliminadoEncriptado = URLEncryptionUtil.encriptarId((Integer)idEliminado);
            return ResponseEntity.ok((Object)("{\"mensaje\": \"Administrador eliminado correctamente\", \"idAdministrador\": \"" + idEliminadoEncriptado + "\"}"));
        }
        catch (Exception e) {
            return ResponseEntity.internalServerError().body((Object)("{\"error\": \"" + e.getMessage() + "\"}"));
        }
    }
}

