/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.AuditService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@SecurityRequirement(name="bearerAuth")
@RestController
@RequestMapping(value={"/api/auditoria"})
@Tag(name="Auditor\u00eda", description="Gesti\u00f3n de logs y auditor\u00eda del sistema")
public class AuditController {
    @Autowired
    private AuditService auditService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    private static final int ID_MODULO_AUDITORIA = 12;

    @Operation(summary="Obtener todos los logs de auditor\u00eda (Solo Admin)")
    @GetMapping
    public ResponseEntity<?> obtenerLogs() {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 12, "pView")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para ver auditor\u00eda\"}");
        }
        List logs = this.auditService.obtenerTodosLogs();
        return ResponseEntity.ok((Object)logs);
    }

    @Operation(summary="Obtener logs de un usuario espec\u00edfico")
    @GetMapping(value={"/usuario/{usuario}"})
    public ResponseEntity<?> obtenerLogsPorUsuario(@PathVariable String usuario) {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 12, "pView")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso\"}");
        }
        List logs = this.auditService.obtenerLogsPorUsuario(usuario);
        return ResponseEntity.ok((Object)logs);
    }

    @Operation(summary="Obtener logs por tipo de acci\u00f3n")
    @GetMapping(value={"/accion/{accion}"})
    public ResponseEntity<?> obtenerLogsPorAccion(@PathVariable String accion) {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 12, "pView")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso\"}");
        }
        List logs = this.auditService.obtenerLogsPorAccion(accion);
        return ResponseEntity.ok((Object)logs);
    }
}

