/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Repository.UsuarioRepository;
import Proyecto.MegaWeb2.__BackEnd.Security.JwtUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.EmailService;
import Proyecto.MegaWeb2.__BackEnd.Service.TwoFactorService;
import Proyecto.MegaWeb2.__BackEnd.Service.UsuarioService;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    @Autowired
    private UsuarioService usuarioService;
    @Autowired
    private UsuarioRepository usuarioRepository;
    @Autowired
    private TwoFactorService twoFactorService;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    private EmailService emailService;

    private Map<String, Object> createResponse(String status, String message, Object data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("message", message);
        map.put("data", data);
        return map;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<?> login(@RequestBody Map<String, String> body) {
        String email = body.get("email");
        String password = body.get("password");
        if (email == null || password == null || email.isEmpty() || password.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)this.createResponse("error", "Faltan datos de login", null));
        }
        try {
            UsuarioDTO user = this.usuarioService.authenticateByEmail(email, password);
            if (user == null) {
                UsuarioDTO userExist = this.usuarioService.findByEmail(email);
                if (userExist == null) {
                    return ResponseEntity.status((int)404).body((Object)this.createResponse("error", "Correo no registrado", null));
                }
                return ResponseEntity.status((int)401).body((Object)this.createResponse("error", "Contrase\u00f1a incorrecta", null));
            }
            if (user.getEstado() == 0) {
                return ResponseEntity.status((int)403).body((Object)this.createResponse("error", "Usuario desactivado", null));
            }
            String codigo6 = this.twoFactorService.generarCodigo6Digitos(email);
            this.usuarioService.updateSecret2FA(email, codigo6);
            String asunto = "\ud83d\udd10 C\u00f3digo de verificaci\u00f3n - MegaWeb";
            String mensajeHtml = "<!DOCTYPE html><html lang='es'><head><meta charset='UTF-8'><meta name='viewport' content='width=device-width, initial-scale=1.0'><title>C\u00f3digo de verificaci\u00f3n</title></head><body style='margin:0;padding:0;background-color:#f4f6f8;font-family:Arial,Helvetica,sans-serif;'><table width='100%' cellpadding='0' cellspacing='0' style='padding:30px 10px;'><tr><td align='center'><table width='600' cellpadding='0' cellspacing='0' style='background:#ffffff;border-radius:14px;box-shadow:0 8px 24px rgba(0,0,0,0.08);overflow:hidden;'><tr><td style='background:#1e88e5;padding:25px;text-align:center;'><h1 style='color:#ffffff;margin:0;font-size:24px;letter-spacing:0.5px;'>MegaWeb</h1><p style='color:#e3f2fd;margin:6px 0 0;font-size:14px;'>Seguridad de tu cuenta</p></td></tr><tr><td style='padding:35px 40px;color:#444;font-size:15px;line-height:1.7;'><h2 style='margin-top:0;color:#2c3e50;font-size:20px;'>\ud83d\udd10 C\u00f3digo de verificaci\u00f3n</h2><p>Hola,</p><p>Tu c\u00f3digo de verificaci\u00f3n para acceder a tu cuenta es:</p><div style='text-align:center;margin:25px 0;'><span style='font-size:28px;font-weight:bold;color:#1e88e5;padding:12px 20px;border:2px dashed #1e88e5;border-radius:8px;display:inline-block;'>" + codigo6 + "</span></div><p style='font-size:14px;color:#555;'>Ingresa este c\u00f3digo en la aplicaci\u00f3n. Expira en 5 minutos.</p><div style='background:#f5f7fa;padding:12px 16px;border-radius:8px;margin-top:20px;'><p style='margin:0;font-size:13px;color:#666;'>\u23f0 <b>Importante:</b> Este c\u00f3digo solo ser\u00e1 v\u00e1lido por 5 minutos.</p></div></td></tr><tr><td style='background:#fafafa;padding:20px;text-align:center;border-top:1px solid #eee;'><p style='margin:0;font-size:12px;color:#999;'>\u00a9 2025 MegaWeb \u00b7 Todos los derechos reservados</p><p style='margin:6px 0 0;font-size:12px;color:#bbb;'>Este es un correo autom\u00e1tico, por favor no respondas</p></td></tr></table></td></tr></table></body></html>";
            this.emailService.enviarCorreo(email, asunto, mensajeHtml);
            HashMap<String, Object> responseData = new HashMap<String, Object>();
            responseData.put("username", email);
            responseData.put("require2FA", true);
            return ResponseEntity.ok((Object)this.createResponse("success", "Se ha generado un c\u00f3digo y se ha enviado a tu correo", responseData));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.status((int)500).body((Object)this.createResponse("error", "Error interno del servidor: " + e.getMessage(), null));
        }
    }

    @PostMapping(value={"/forgot-password"})
    public ResponseEntity<?> recuperarPassword(@RequestBody Map<String, String> body) {
        String email = body.get("email");
        if (email == null || email.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)this.createResponse("error", "Falta el correo electr\u00f3nico", null));
        }
        UsuarioDTO user = this.usuarioService.findByEmail(email);
        if (user == null) {
            return ResponseEntity.status((int)404).body((Object)this.createResponse("error", "Usuario no encontrado", null));
        }
        String token = this.jwtUtil.generateTemporaryToken(email, Duration.ofMinutes(15L));
        String resetLink = "https://magical-sprite-7a5679.netlify.app/reset-password?token=" + token;
        String asunto = "\ud83d\udd10 Recupera tu contrase\u00f1a - MegaWeb";
        String mensajeHtml = "<!DOCTYPE html><html lang='es'><head><meta charset='UTF-8'><meta name='viewport' content='width=device-width, initial-scale=1.0'><title>Recuperaci\u00f3n de contrase\u00f1a</title></head><body style='margin:0;padding:0;background-color:#f4f6f8;font-family:Arial,Helvetica,sans-serif;'><table width='100%' cellpadding='0' cellspacing='0' style='padding:30px 10px;'><tr><td align='center'><table width='600' cellpadding='0' cellspacing='0' style='background:#ffffff;border-radius:14px;box-shadow:0 8px 24px rgba(0,0,0,0.08);overflow:hidden;'><tr><td style='background:#1e88e5;padding:25px;text-align:center;'><h1 style='color:#ffffff;margin:0;font-size:24px;letter-spacing:0.5px;'>MegaWeb</h1><p style='color:#e3f2fd;margin:6px 0 0;font-size:14px;'>Seguridad de tu cuenta</p></td></tr><tr><td style='padding:35px 40px;color:#444;font-size:15px;line-height:1.7;'><h2 style='margin-top:0;color:#2c3e50;font-size:20px;'>\ud83d\udd10 Recuperaci\u00f3n de contrase\u00f1a</h2><p>Hola,</p><p>Hemos recibido una solicitud para restablecer la contrase\u00f1a de tu cuenta en <b>MegaWeb</b>.</p><p>Para continuar, haz clic en el bot\u00f3n de abajo:</p><div style='text-align:center;margin:35px 0;'><a href='" + resetLink + "' style='background:#1e88e5;color:#ffffff;text-decoration:none;padding:14px 36px;border-radius:8px;font-weight:bold;font-size:15px;display:inline-block;box-shadow:0 6px 16px rgba(30,136,229,0.4);'>Restablecer contrase\u00f1a</a></div><p style='font-size:14px;color:#555;'>Si no solicitaste este cambio, puedes ignorar este correo de forma segura.</p><div style='background:#f5f7fa;padding:12px 16px;border-radius:8px;margin-top:20px;'><p style='margin:0;font-size:13px;color:#666;'>\u23f0 <b>Importante:</b> Este enlace expirar\u00e1 en 15 minutos.</p></div></td></tr><tr><td style='background:#fafafa;padding:20px;text-align:center;border-top:1px solid #eee;'><p style='margin:0;font-size:12px;color:#999;'>\u00a9 2025 MegaWeb \u00b7 Todos los derechos reservados</p><p style='margin:6px 0 0;font-size:12px;color:#bbb;'>Este es un correo autom\u00e1tico, por favor no respondas</p></td></tr></table></td></tr></table></body></html>";
        this.emailService.enviarCorreo(email, asunto, mensajeHtml);
        return ResponseEntity.ok((Object)this.createResponse("success", "Correo de recuperaci\u00f3n enviado", null));
    }

    @PostMapping(value={"/restablecer-password"})
    public ResponseEntity<?> restablecerPassword(@RequestBody Map<String, String> body) {
        String token = body.get("token");
        String nuevaPassword = body.get("password");
        if (token == null || nuevaPassword == null) {
            return ResponseEntity.badRequest().body((Object)this.createResponse("error", "Datos incompletos", null));
        }
        String email = this.jwtUtil.validarYObtenerEmail(token);
        if (email == null) {
            return ResponseEntity.status((int)400).body((Object)this.createResponse("error", "Token inv\u00e1lido o expirado", null));
        }
        UsuarioDTO user = this.usuarioService.findByEmail(email);
        if (user == null) {
            return ResponseEntity.status((int)404).body((Object)this.createResponse("error", "Usuario no encontrado", null));
        }
        this.usuarioService.updatePassword(email, nuevaPassword);
        return ResponseEntity.ok((Object)this.createResponse("success", "Contrase\u00f1a actualizada correctamente", null));
    }

    @PostMapping(value={"/verify-2fa"})
    public ResponseEntity<?> verify2FA(@RequestBody Map<String, String> body) {
        String code = body.get("code");
        if (code == null || code.isEmpty()) {
            return ResponseEntity.badRequest().body(Map.of("valid", false, "message", "C\u00f3digo vac\u00edo"));
        }
        UsuarioDTO user = this.usuarioRepository.findBySecret2FA(code);
        if (user == null) {
            return ResponseEntity.ok(Map.of("valid", false));
        }
        Map tokenData = this.jwtUtil.generateToken(user);
        this.usuarioService.updateSecret2FA(user.getEmail(), null);
        return ResponseEntity.ok(Map.of("valid", true, "token", tokenData.get("token"), "expiration", tokenData.get("expiration")));
    }
}

