/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.ClienteListadoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.CrearClienteDTO;
import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.AuditService;
import Proyecto.MegaWeb2.__BackEnd.Service.ClienteService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import Proyecto.MegaWeb2.__BackEnd.Util.URLEncryptionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/clientes"})
@Tag(name="Clientes", description="Lista de clientes visibles en la web")
public class ClienteController {
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    @Autowired
    private AuditService auditService;
    private static final int ID_MODULO_CLIENTES = 4;

    private String obtenerIPCliente(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }

    @Operation(summary="Listar clientes activos", description="Devuelve una lista de clientes con nombre e imagen")
    @GetMapping
    public ResponseEntity<List<ClienteListadoDTO>> listarClientes() {
        return ResponseEntity.ok((Object)this.clienteService.listarClientes());
    }

    @Operation(summary="Vista de cliente: productos asignados", description="Devuelve los productos asociados al cliente")
    @GetMapping(value={"/vista/{idClienteEncriptado}"})
    public ResponseEntity<?> vistaCliente(@PathVariable String idClienteEncriptado) {
        try {
            Integer idCliente = URLEncryptionUtil.desencriptarId((String)idClienteEncriptado);
            if (idCliente == null) {
                return ResponseEntity.status((int)400).body((Object)"{\"error\": \"ID inv\u00e1lido\"}");
            }
            List vista = this.clienteService.obtenerVistaCliente(idCliente.intValue());
            return ResponseEntity.ok((Object)vista);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)400).body((Object)"{\"error\": \"Error al procesar la solicitud\"}");
        }
    }

    @Operation(summary="Registrar un nuevo cliente", description="Registra un nuevo cliente en la base de datos")
    @PostMapping
    @SecurityRequirement(name="bearerAuth")
    public ResponseEntity<?> registrarCliente(@RequestParam String empresa, @RequestParam String descripcion, @RequestParam String ruc, @RequestParam(required=false) String grupo, @RequestParam String contacto, @RequestParam(required=false) String nombreComercial, @RequestParam String telefono, @RequestParam String localidad, @RequestParam(required=false) String direccion, @RequestParam(required=false) String imagen, @RequestParam Short showWeb, HttpServletRequest request) {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 4, "pCreate")) {
            this.auditService.registrarDenegacionPermiso("ADMIN", "/api/clientes", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para registrar clientes\"}");
        }
        CrearClienteDTO dto = new CrearClienteDTO();
        dto.setEmpresa(empresa);
        dto.setDescripcion(descripcion);
        dto.setNruc(ruc);
        dto.setGrupo(grupo);
        dto.setContacto(contacto);
        dto.setNombreComercial(nombreComercial);
        dto.setTelefono(telefono);
        dto.setDireccion(direccion);
        dto.setLocalidad(localidad);
        dto.setLogo(imagen);
        dto.setShowWeb(showWeb);
        try {
            boolean creado = this.clienteService.crearCliente(dto);
            if (creado) {
                this.auditService.registrarEvento("ADMIN", "CREAR_CLIENTE", "Cliente creado: " + empresa, ipCliente, "/api/clientes", "POST");
                return ResponseEntity.ok((Object)"{\"mensaje\": \"Cliente registrado correctamente\"}");
            }
            return ResponseEntity.status((int)500).body((Object)"{\"error\": \"No se pudo registrar el cliente\"}");
        }
        catch (Exception e) {
            return ResponseEntity.status((int)400).body((Object)("{\"error\": \"" + e.getMessage() + "\"}"));
        }
    }
}

