/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.A\u00f1adirComentarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ComentarioResponseDTO;
import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.ComentarioService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/comentarios"})
@Tag(name="Comentarios", description="Gesti\u00f3n de comentarios")
public class ComentarioController {
    @Autowired
    private ComentarioService comentarioService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    private static final int ID_MODULO_COMENTARIOS = 11;

    @Operation(summary="Listar comentarios publicados", description="Lista todos los comentarios o solo los de una consulta espec\u00edfica si se proporciona idConsulta", parameters={@Parameter(name="idConsulta", description="ID de la consulta a filtrar (opcional)")})
    @GetMapping
    public ResponseEntity<List<ComentarioResponseDTO>> listar() {
        List comentarios = this.comentarioService.listarComentarios();
        return ResponseEntity.ok((Object)comentarios);
    }

    @Operation(summary="Publicar un comentario (requiere autenticaci\u00f3n y permiso de creaci\u00f3n)")
    @PostMapping
    public ResponseEntity<?> registrarComentario(@RequestBody A\u00f1adirComentarioDTO dto) {
        Integer idUsuario = UsuarioSesionUtil.getIdUsuarioActual();
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        if (idUsuario == null || idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        int ID_MODULO_COMENTARIOS = 11;
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 11, "pCreate")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para comentar\"}");
        }
        int result = this.comentarioService.registrarComentario(dto, idUsuario.intValue());
        if (result > 0) {
            return ResponseEntity.ok((Object)"{\"status\": \"Comentario registrado\"}");
        }
        return ResponseEntity.status((int)400).body((Object)"{\"error\": \"Usuario o consulta no v\u00e1lida\"}");
    }
}

