/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.ConsultaListadoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.VistaConsultaDTO;
import Proyecto.MegaWeb2.__BackEnd.Service.ConsultaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/consultas"})
@Tag(name="Consultas", description="Vista de consultas con su producto relacionado")
public class ConsultaController {
    @Autowired
    private ConsultaService consultaService;

    @Operation(summary="Listar todas las consultas con su producto")
    @GetMapping
    public ResponseEntity<List<ConsultaListadoDTO>> listarConsultas() {
        List consultas = this.consultaService.listarConsultas();
        return ResponseEntity.ok((Object)consultas);
    }

    @Operation(summary="Obtener detalles de una consulta", description="Devuelve t\u00edtulo, producto, descripci\u00f3n, pasos e im\u00e1genes de una consulta", parameters={@Parameter(name="idConsulta", description="ID de la consulta", required=true)}, responses={@ApiResponse(responseCode="200", description="Consulta obtenida"), @ApiResponse(responseCode="404", description="Consulta no encontrada")})
    @GetMapping(value={"/vista"})
    public ResponseEntity<?> obtenerConsulta(@RequestParam int idConsulta) {
        VistaConsultaDTO consulta = this.consultaService.obtenerConsulta(idConsulta);
        if (consulta == null) {
            return ResponseEntity.status((int)404).body((Object)"{\"error\": \"Consulta no encontrada\"}");
        }
        return ResponseEntity.ok((Object)consulta);
    }
}

