/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.NosotrosDTO;
import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.EmpresaService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/nosotros"})
@Tag(name="Nosotros", description="Informaci\u00f3n de la empresa: descripci\u00f3n, misi\u00f3n y visi\u00f3n")
@SecurityRequirement(name="bearerAuth")
public class EmpresaController {
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;

    @Operation(summary="Obtener informaci\u00f3n institucional")
    @GetMapping
    public ResponseEntity<?> obtenerInformacion() {
        NosotrosDTO dto = this.empresaService.obtenerInformacionEmpresa();
        if (dto == null) {
            return ResponseEntity.status((int)404).body((Object)"{\"error\": \"No se encontr\u00f3 informaci\u00f3n de la empresa\"}");
        }
        return ResponseEntity.ok((Object)dto);
    }

    @Operation(summary="Actualizar informaci\u00f3n institucional (campos opcionales)")
    @PutMapping
    public ResponseEntity<?> actualizarInformacion(@RequestParam(required=false) String descripcion, @RequestParam(required=false) String mision, @RequestParam(required=false) String vision, @RequestParam(required=false) String telefono, @RequestParam(required=false) String direccion, HttpServletRequest request) {
        boolean actualizado;
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        int ID_MODULO_NOSOTROS = 10;
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 10, "pUpdate")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para actualizar la informaci\u00f3n de la empresa\"}");
        }
        NosotrosDTO actual = this.empresaService.obtenerInformacionEmpresa();
        if (actual == null) {
            return ResponseEntity.status((int)404).body((Object)"{\"error\": \"No se encontr\u00f3 informaci\u00f3n de la empresa\"}");
        }
        if (descripcion != null) {
            actual.setDescripcion(descripcion);
        }
        if (mision != null) {
            actual.setMision(mision);
        }
        if (vision != null) {
            actual.setVision(vision);
        }
        if (telefono != null) {
            actual.setTelefono(telefono);
        }
        if (direccion != null) {
            actual.setDireccion(direccion);
        }
        if (actualizado = this.empresaService.actualizarInformacionEmpresa(actual)) {
            return ResponseEntity.ok((Object)"{\"status\": \"Informaci\u00f3n actualizada correctamente\"}");
        }
        return ResponseEntity.status((int)500).body((Object)"{\"error\": \"No se pudo actualizar la informaci\u00f3n\"}");
    }
}

