/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Service.FirmaPdfService;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/firma"})
@Tag(name="Firmas", description="Firma digital PDF con Apache PDFBox y BouncyCastle")
public class FirmaController {
    @Autowired
    private FirmaPdfService firmaPdfService;

    @PostMapping(consumes={"multipart/form-data"})
    public ResponseEntity<byte[]> firmarPdf(@RequestPart(value="file") MultipartFile archivo, @RequestHeader(value="Authorization") String authHeader) {
        try {
            if (archivo.isEmpty()) {
                return ResponseEntity.badRequest().body((Object)"Debe subir un archivo PDF".getBytes());
            }
            if (!archivo.getContentType().equalsIgnoreCase("application/pdf")) {
                return ResponseEntity.badRequest().body((Object)"El archivo debe ser PDF".getBytes());
            }
            if (archivo.getSize() > 0x500000L) {
                return ResponseEntity.badRequest().body((Object)"El archivo no debe superar los 5 MB".getBytes());
            }
            String token = authHeader.replace("Bearer ", "");
            byte[] pdfFirmado = this.firmaPdfService.firmarPdf(archivo.getBytes(), token);
            return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", new String[]{"application/pdf"})).header("Content-Disposition", new String[]{"attachment; filename=\"documento_firmado.pdf\""})).body((Object)pdfFirmado);
        }
        catch (Exception e) {
            return ResponseEntity.internalServerError().body((Object)("Error al firmar el documento: " + e.getMessage()).getBytes());
        }
    }
}

