/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.LicenciaService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SecurityRequirement(name="bearerAuth")
@RestController
@RequestMapping(value={"/api/licencias"})
@Tag(name="Licencias de Clientes", description="Consulta de licencias activas por cliente")
public class LicenciaController {
    @Autowired
    private LicenciaService licenciaService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    private static final int ID_MODULO_SOPORTE = 8;

    @Operation(summary="Consultar licencias por cliente", description="Permite consultar todas las licencias activas o filtrar por ID de cliente.", parameters={@Parameter(name="idCliente", description="ID del cliente a consultar (opcional)", required=false)}, responses={@ApiResponse(responseCode="200", description="Consulta exitosa"), @ApiResponse(responseCode="403", description="No tienes permiso para ver licencias"), @ApiResponse(responseCode="500", description="Error interno del servidor")})
    @GetMapping
    public ResponseEntity<?> consultarLicencias(@RequestParam(required=false) Integer idCliente) {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 8, "pView")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para consultar licencias\"}");
        }
        List licencias = this.licenciaService.consultarLicencias(idCliente);
        if (idCliente != null && licencias.isEmpty()) {
            return ResponseEntity.status((int)404).body((Object)"{\"error\": \"Cliente no encontrado o sin licencias\"}");
        }
        return ResponseEntity.ok((Object)licencias);
    }
}

