/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.PermisoRolModuloAsignarDTO;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SecurityRequirement(name="bearerAuth")
@RestController
@RequestMapping(value={"/api/permisos-rol-modulo"})
@Tag(name="Permisos por Rol y M\u00f3dulo", description="Endpoints para consultar y gestionar los permisos de un rol sobre los m\u00f3dulos del sistema.")
public class PermisoRolModuloController {
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    private final int ID_MODULO_ACCESOS = 7;

    @Operation(summary="Obtener los permisos de un rol sobre todos los m\u00f3dulos", description="Devuelve una lista de m\u00f3dulos y los permisos asociados (ver, crear, editar, eliminar) para el rol especificado.", parameters={@Parameter(name="idRol", description="ID del rol a consultar", required=true)}, responses={@ApiResponse(responseCode="200", description="Permisos obtenidos correctamente"), @ApiResponse(responseCode="403", description="No autorizado")})
    @GetMapping(value={"/{idRol}"})
    public ResponseEntity<?> listarPermisosPorRol(@PathVariable int idRol, HttpServletRequest request) {
        Integer rolActual = (Integer)request.getAttribute("idRol");
        if (rolActual == null || !this.permisoRolModuloService.tienePermiso(rolActual.intValue(), 7, "pView")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para ver accesos\"}");
        }
        List permisos = this.permisoRolModuloService.listarPermisosPorRol(idRol);
        return ResponseEntity.ok((Object)permisos);
    }

    @Operation(summary="Asignar o actualizar permisos de un rol sobre un m\u00f3dulo", description="Permite asignar o actualizar los permisos (ver, crear, editar, eliminar) de un rol sobre un m\u00f3dulo espec\u00edfico.", parameters={@Parameter(name="idRol", description="ID del rol", required=true), @Parameter(name="idModulo", description="ID del m\u00f3dulo", required=true), @Parameter(name="pView", description="Permiso ver (1 o 0)", required=true), @Parameter(name="pCreate", description="Permiso crear (1 o 0)", required=true), @Parameter(name="pUpdate", description="Permiso editar (1 o 0)", required=true), @Parameter(name="pDelete", description="Permiso eliminar (1 o 0)", required=true)})
    @PutMapping(value={"/asignar"})
    public ResponseEntity<?> asignarPermisosRolModulo(@RequestParam int idRol, @RequestParam int idModulo, @RequestParam int pView, @RequestParam int pCreate, @RequestParam int pUpdate, @RequestParam int pDelete, HttpServletRequest request) {
        Integer rolActual = (Integer)request.getAttribute("idRol");
        if (rolActual == null || !this.permisoRolModuloService.tienePermiso(rolActual.intValue(), 7, "pCreate")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para asignar accesos\"}");
        }
        PermisoRolModuloAsignarDTO dto = new PermisoRolModuloAsignarDTO();
        dto.setIdRol(idRol);
        dto.setIdModulo(idModulo);
        dto.setpView(pView);
        dto.setpCreate(pCreate);
        dto.setpUpdate(pUpdate);
        dto.setpDelete(pDelete);
        int result = this.permisoRolModuloService.asignarPermisosRolModulo(dto);
        if (result > 0) {
            return ResponseEntity.ok().body((Object)"{\"status\": \"Permisos asignados o actualizados correctamente\"}");
        }
        return ResponseEntity.status((int)500).body((Object)"{\"error\": \"No se pudo asignar/actualizar permisos\"}");
    }
}

