/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.ActualizarProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.CrearProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ListarProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.VistaProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.AuditService;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import Proyecto.MegaWeb2.__BackEnd.Service.ProductoService;
import Proyecto.MegaWeb2.__BackEnd.Util.URLEncryptionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/productos"})
@Tag(name="Productos", description="API para gestionar productos")
public class ProductoController {
    @Autowired
    private ProductoService productoService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    @Autowired
    private AuditService auditService;
    private static final int ID_MODULO_PRODUCTOS = 5;

    private String obtenerIPCliente(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }

    @Operation(summary="Listar productos disponibles", description="Devuelve una lista con imagen, nombre y descripci\u00f3n de los productos.", responses={@ApiResponse(responseCode="200", description="Lista obtenida con \u00e9xito")})
    @GetMapping
    public ResponseEntity<List<ListarProductoDTO>> listar() {
        return ResponseEntity.ok((Object)this.productoService.listarProductos());
    }

    @GetMapping(value={"/{idEncriptado}"})
    public ResponseEntity<?> verDetalleProducto(@PathVariable String idEncriptado) {
        try {
            Integer idReal = URLEncryptionUtil.desencriptarId((String)idEncriptado);
            if (idReal == null) {
                return ResponseEntity.status((int)400).body((Object)"{\"error\": \"ID inv\u00e1lido\"}");
            }
            VistaProductoDTO dto = this.productoService.obtenerVistaProducto(idReal.intValue());
            if (dto == null || dto.getNombre() == null) {
                return ResponseEntity.status((int)404).body((Object)"{\"error\": \"Producto no encontrado\"}");
            }
            return ResponseEntity.ok((Object)dto);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)400).body((Object)"{\"error\": \"Error al procesar la solicitud\"}");
        }
    }

    @Operation(summary="Crear un nuevo producto", description="Registra un nuevo producto en la base de datos.", responses={@ApiResponse(responseCode="200", description="Producto creado correctamente"), @ApiResponse(responseCode="403", description="No tienes permisos"), @ApiResponse(responseCode="500", description="Error al crear el producto")})
    @PostMapping
    @SecurityRequirement(name="bearerAuth")
    public ResponseEntity<?> crear(@RequestBody CrearProductoDTO dto, HttpServletRequest request) {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 5, "pCreate")) {
            this.auditService.registrarDenegacionPermiso("ADMIN", "/api/productos", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para crear productos\"}");
        }
        int idProducto = this.productoService.crearProducto(dto);
        if (idProducto > 0) {
            String idEncriptado = URLEncryptionUtil.encriptarId((Integer)idProducto);
            this.auditService.registrarEvento("ADMIN", "CREAR_PRODUCTO", "Producto creado: " + dto.getNombre(), ipCliente, "/api/productos", "POST");
            return ResponseEntity.ok().body((Object)("{\"idProducto\": \"" + idEncriptado + "\"}"));
        }
        return ResponseEntity.status((int)500).body((Object)"{\"error\": \"No se pudo crear el producto\"}");
    }

    @PutMapping
    @SecurityRequirement(name="bearerAuth")
    public ResponseEntity<?> actualizar(@RequestBody ActualizarProductoDTO dto, HttpServletRequest request) {
        Integer idRol = UsuarioSesionUtil.getIdRolActual();
        String ipCliente = this.obtenerIPCliente(request);
        if (idRol == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        int ID_MODULO_PRODUCTS = 5;
        if (!this.permisoRolModuloService.tienePermiso(idRol.intValue(), 5, "pUpdate")) {
            this.auditService.registrarDenegacionPermiso("ADMIN", "/api/productos", ipCliente);
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permiso para actualizar productos\"}");
        }
        boolean actualizado = this.productoService.actualizarProducto(dto);
        if (actualizado) {
            this.auditService.registrarEvento("ADMIN", "ACTUALIZAR_PRODUCTO", "Producto actualizado ID: " + dto.getId(), ipCliente, "/api/productos", "PUT");
            return ResponseEntity.ok((Object)"{\"status\": \"Producto actualizado correctamente\"}");
        }
        return ResponseEntity.status((int)500).body((Object)"{\"error\": \"No se pudo actualizar el producto\"}");
    }
}

