/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.RolDTO;
import Proyecto.MegaWeb2.__BackEnd.Security.UsuarioSesionUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.PermisoRolModuloService;
import Proyecto.MegaWeb2.__BackEnd.Service.RolService;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SecurityRequirement(name="bearerAuth")
@RestController
@RequestMapping(value={"/api/roles"})
public class RolController {
    @Autowired
    private RolService rolService;
    @Autowired
    private PermisoRolModuloService permisoRolModuloService;
    private static final int ID_MODULO_ROLES = 9;

    @PostMapping
    public ResponseEntity<?> crearRol(@RequestBody RolDTO dto) {
        Integer idRolActual = UsuarioSesionUtil.getIdRolActual();
        if (idRolActual == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRolActual.intValue(), 9, "pCreate")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para crear roles\"}");
        }
        int idRol = this.rolService.crearRol(dto);
        return ResponseEntity.ok().body((Object)("{\"idRol\": " + idRol + "}"));
    }

    @GetMapping
    public ResponseEntity<?> listar(@RequestParam(required=false) Integer id) {
        Integer idRolActual = UsuarioSesionUtil.getIdRolActual();
        if (idRolActual == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        if (!this.permisoRolModuloService.tienePermiso(idRolActual.intValue(), 9, "pView")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para ver roles\"}");
        }
        List roles = this.rolService.listarRoles(id);
        if (id != null) {
            if (roles.isEmpty()) {
                return ResponseEntity.notFound().build();
            }
            return ResponseEntity.ok((Object)((RolDTO)roles.get(0)));
        }
        return ResponseEntity.ok((Object)roles);
    }

    @PutMapping(value={"/{idRol}"})
    public ResponseEntity<?> actualizarRol(@PathVariable int idRol, @RequestParam String nombre) {
        Integer idRolActual = UsuarioSesionUtil.getIdRolActual();
        if (idRolActual == null) {
            return ResponseEntity.status((int)401).body((Object)"{\"error\": \"No autenticado\"}");
        }
        int ID_MODULO_ROLES = 9;
        if (!this.permisoRolModuloService.tienePermiso(idRolActual.intValue(), 9, "pUpdate")) {
            return ResponseEntity.status((int)403).body((Object)"{\"error\": \"No tienes permisos para actualizar roles\"}");
        }
        RolDTO dto = new RolDTO();
        dto.setIdRol(idRol);
        dto.setNombre(nombre);
        int actualizado = this.rolService.actualizarRol(dto);
        if (actualizado > 0) {
            return ResponseEntity.ok().body((Object)"{\"status\": \"Rol actualizado correctamente\"}");
        }
        return ResponseEntity.status((int)404).body((Object)"{\"error\": \"Rol no encontrado\"}");
    }
}

