/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Controller;

import Proyecto.MegaWeb2.__BackEnd.Dto.EditarUsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ListarUsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioCreateRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Service.AuditService;
import Proyecto.MegaWeb2.__BackEnd.Service.UsuarioService;
import Proyecto.MegaWeb2.__BackEnd.Util.URLEncryptionUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth/usuarios"})
public class UsuarioController {
    private final UsuarioService usuarioService;
    private final AuditService auditService;

    @Autowired
    public UsuarioController(UsuarioService usuarioService, AuditService auditService) {
        this.usuarioService = usuarioService;
        this.auditService = auditService;
    }

    private String obtenerIPCliente(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }

    private String obtenerUsuarioActual(HttpServletRequest request) {
        String usuario = (String)request.getAttribute("username");
        return usuario != null ? usuario : "ANONYMOUS";
    }

    @PostMapping
    public ResponseEntity<Map<String, Object>> crearUsuario(@Valid @RequestBody UsuarioCreateRequestDTO dto, HttpServletRequest request) {
        String ipCliente = this.obtenerIPCliente(request);
        try {
            int idUsuario = this.usuarioService.crearUsuario(dto);
            if (idUsuario > 0) {
                String idEncriptado = URLEncryptionUtil.encriptarId((Integer)idUsuario);
                this.auditService.registrarEvento("SISTEMA", "CREAR_USUARIO", "Usuario creado: " + dto.getEmail(), ipCliente, "/api/auth/usuarios", "POST");
                return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body(Map.of("idUsuario", idEncriptado, "status", "success"));
            }
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "No se pudo crear el usuario"));
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(Map.of("error", e.getMessage()));
        }
    }

    @GetMapping
    public ResponseEntity<List<ListarUsuarioDTO>> listarUsuarios(HttpServletRequest request) {
        String ipCliente = this.obtenerIPCliente(request);
        this.auditService.registrarAccesoRecurso("ADMIN", "/api/auth/usuarios", ipCliente);
        List lista = this.usuarioService.listarUsuarios(null);
        return ResponseEntity.ok((Object)lista);
    }

    @GetMapping(value={"/{idEncriptado}"})
    public ResponseEntity<?> obtenerUsuario(@PathVariable String idEncriptado, HttpServletRequest request) {
        String ipCliente = this.obtenerIPCliente(request);
        try {
            Integer id = URLEncryptionUtil.desencriptarId((String)idEncriptado);
            if (id == null) {
                return ResponseEntity.badRequest().body(Map.of("error", "ID inv\u00e1lido"));
            }
            List lista = this.usuarioService.listarUsuarios(id);
            if (lista.isEmpty()) {
                return ResponseEntity.notFound().build();
            }
            this.auditService.registrarAccesoRecurso("ADMIN", "/api/auth/usuarios/" + id, ipCliente);
            return ResponseEntity.ok((Object)((ListarUsuarioDTO)lista.get(0)));
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(Map.of("error", "Error al procesar ID"));
        }
    }

    @PutMapping
    public ResponseEntity<?> editarUsuario(@RequestBody EditarUsuarioDTO dto, HttpServletRequest request) {
        String ipCliente = this.obtenerIPCliente(request);
        String usuarioActual = this.obtenerUsuarioActual(request);
        try {
            this.usuarioService.editarUsuario(dto);
            this.auditService.registrarEvento(usuarioActual, "ACTUALIZAR_USUARIO", "Usuario actualizado (DTO ID: " + dto.getId() + ")", ipCliente, "/api/auth/usuarios", "PUT");
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(Map.of("error", "Error al actualizar usuario: " + e.getMessage()));
        }
    }

    @DeleteMapping(value={"/{idEncriptado}"})
    public ResponseEntity<?> eliminarUsuario(@PathVariable String idEncriptado, HttpServletRequest request) {
        String ipCliente = this.obtenerIPCliente(request);
        String usuarioActual = this.obtenerUsuarioActual(request);
        try {
            Integer id = URLEncryptionUtil.desencriptarId((String)idEncriptado);
            if (id == null) {
                return ResponseEntity.badRequest().body(Map.of("error", "ID inv\u00e1lido o manipulado"));
            }
            this.usuarioService.eliminarUsuario(id);
            this.auditService.registrarEliminacion(usuarioActual, id, "USUARIO", ipCliente);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Error al eliminar usuario"));
        }
    }
}

