/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Repository;

import Proyecto.MegaWeb2.__BackEnd.Dto.A\u00f1adirComentarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ComentarioResponseDTO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class ComentarioRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<ComentarioResponseDTO> listarComentarios() {
        String sql = "CALL sp_listar_comentarios()";
        return this.jdbcTemplate.query(sql, (rs, rowNum) -> {
            ComentarioResponseDTO dto = new ComentarioResponseDTO();
            dto.setIdComentario(rs.getInt("idcomentario"));
            dto.setComentario(rs.getString("comentario"));
            dto.setFecha(rs.getTimestamp("fecha").toLocalDateTime());
            dto.setNombres(rs.getString("nombres"));
            dto.setApellidos(rs.getString("apellidos"));
            dto.setImagenUsuario(rs.getString("imagen_usuario"));
            dto.setNombreEmpresa(rs.getString("nombre_empresa"));
            return dto;
        });
    }

    public int registrarComentario(A\u00f1adirComentarioDTO dto, int idUsuario) {
        try {
            this.jdbcTemplate.update("CALL sp_insertar_comentario(?, ?, ?)", new Object[]{dto.getComentario(), idUsuario, dto.getIdConsulta()});
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error al registrar comentario: " + e.getMessage());
            return 0;
        }
    }
}

