/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Repository;

import Proyecto.MegaWeb2.__BackEnd.Dto.EmpresaCreateRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.NosotrosDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class EmpresaRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public NosotrosDTO obtenerInformacionEmpresa() {
        return (NosotrosDTO)this.jdbcTemplate.query("CALL sp_obtener_nosotros()", rs -> {
            if (rs.next()) {
                NosotrosDTO dto = new NosotrosDTO();
                dto.setDescripcion(rs.getString("descripcion"));
                dto.setMision(rs.getString("mision"));
                dto.setVision(rs.getString("vision"));
                dto.setTelefono(rs.getString("telefono"));
                dto.setDireccion(rs.getString("direccion"));
                return dto;
            }
            return null;
        });
    }

    public int actualizarInformacionEmpresa(NosotrosDTO dto) {
        return this.jdbcTemplate.update("CALL sp_actualizar_nosotros(?, ?, ?, ?, ?)", new Object[]{dto.getDescripcion(), dto.getMision(), dto.getVision(), dto.getTelefono(), dto.getDireccion()});
    }

    public int insertarEmpresa(EmpresaCreateRequestDTO dto) {
        return this.jdbcTemplate.update("CALL sp_insertar_empresa(?, ?, ?, ?, ?)", new Object[]{dto.getPresentacion(), dto.getMision(), dto.getVision(), dto.getTelefono(), dto.getDireccion()});
    }
}

