/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Repository;

import Proyecto.MegaWeb2.__BackEnd.Dto.ActualizarProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.CrearProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.DocProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ListarProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.MultimediaProductoDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.VistaProductoDTO;
import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ProductoRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<ListarProductoDTO> listarProductos() {
        return this.jdbcTemplate.query("CALL sp_listar_productos()", (RowMapper)new /* Unavailable Anonymous Inner Class!! */);
    }

    public int crearProducto(CrearProductoDTO dto) {
        return (Integer)this.jdbcTemplate.query("CALL sp_crear_producto(?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{dto.getNombre(), dto.getDescripcion(), dto.getImagen(), dto.getCaracteristicas(), dto.getDescarga(), dto.getVideo(), dto.getCaja(), dto.getTitdescarga(), dto.getUltimaversion()}, rs -> rs.next() ? rs.getInt("idProducto") : 0);
    }

    public int actualizarProducto(ActualizarProductoDTO dto) {
        return this.jdbcTemplate.update("CALL sp_actualizar_producto(?, ?, ?, ?)", new Object[]{dto.getId(), dto.getNombre(), dto.getDescripcion(), dto.getImagen()});
    }

    public VistaProductoDTO obtenerVistaProducto(int idProducto) {
        VistaProductoDTO dto = new VistaProductoDTO();
        this.jdbcTemplate.execute(con -> {
            CallableStatement cs = con.prepareCall("CALL sp_ver_detalle_producto(?)");
            cs.setInt(1, idProducto);
            return cs;
        }, cs -> {
            boolean hasResults = cs.execute();
            if (hasResults) {
                try (ResultSet rs = cs.getResultSet();){
                    if (rs.next()) {
                        dto.setId(rs.getInt("id"));
                        dto.setNombre(rs.getString("nombre"));
                        dto.setDescripcion(rs.getString("descripcion"));
                        dto.setImagen(rs.getString("imagen"));
                        dto.setCaracteristicas(rs.getString("caracteristicas"));
                        dto.setVideo(rs.getString("video"));
                    }
                }
            }
            if (cs.getMoreResults()) {
                try (ResultSet rs2 = cs.getResultSet();){
                    ArrayList<DocProductoDTO> docs = new ArrayList<DocProductoDTO>();
                    while (rs2.next()) {
                        DocProductoDTO doc = new DocProductoDTO();
                        doc.setDocument(rs2.getString("document"));
                        doc.setDescripcion(rs2.getString("descripcion"));
                        docs.add(doc);
                    }
                    dto.setDocumentacion(docs);
                }
            }
            if (cs.getMoreResults()) {
                try (ResultSet rs3 = cs.getResultSet();){
                    ArrayList<MultimediaProductoDTO> imgs = new ArrayList<MultimediaProductoDTO>();
                    while (rs3.next()) {
                        MultimediaProductoDTO img = new MultimediaProductoDTO();
                        img.setImagen(rs3.getString("imagen"));
                        img.setDescripcion(rs3.getString("descripcion"));
                        imgs.add(img);
                    }
                    dto.setMultimedia(imgs);
                }
            }
            return null;
        });
        return dto;
    }
}

