/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Repository;

import Proyecto.MegaWeb2.__BackEnd.Dto.EditarUsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ListarUsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioCreateRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioDTO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class UsuarioRepository {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public UsuarioDTO findBySecret2FA(String secret2FA) {
        String sql = "    SELECT id, nombres, apellidos, email, idRol, estado\n    FROM users\n    WHERE secret_2fa = ?\n";
        return (UsuarioDTO)this.jdbcTemplate.query(sql, new Object[]{secret2FA}, rs -> {
            if (rs.next()) {
                UsuarioDTO dto = new UsuarioDTO();
                dto.setId(Integer.valueOf(rs.getInt("id")));
                dto.setNombres(rs.getString("nombres"));
                dto.setApellidos(rs.getString("apellidos"));
                dto.setEmail(rs.getString("email"));
                dto.setRol(rs.getInt("idRol"));
                dto.setEstado(rs.getInt("estado"));
                return dto;
            }
            return null;
        });
    }

    public void updateSecret2FA(String email, String secret2FA) {
        this.jdbcTemplate.update("UPDATE users SET secret_2fa = ? WHERE email = ?", new Object[]{secret2FA, email});
    }

    public int crearUsuario(UsuarioCreateRequestDTO dto) {
        String sql = "CALL sp_crear_usuario(?, ?, ?, ?, ?, ?,?)";
        Object[] params = new Object[]{dto.getNombres(), dto.getApellidos(), dto.getPassword(), dto.getEmail(), dto.getDni(), dto.getIdRol(), dto.getFirmaBase64()};
        return this.jdbcTemplate.update(sql, params);
    }

    public List<ListarUsuarioDTO> listarUsuarios(Integer id) {
        return this.jdbcTemplate.query("CALL sp_listar_usuarios(?)", new Object[]{id}, (rs, rowNum) -> {
            ListarUsuarioDTO u = new ListarUsuarioDTO();
            u.setId(rs.getInt("id"));
            u.setNombres(rs.getString("nombres"));
            u.setApellidos(rs.getString("apellidos"));
            u.setEmail(rs.getString("email"));
            u.setDni(rs.getString("dni"));
            u.setSuscripcion(rs.getInt("suscripcion"));
            u.setTema(rs.getString("tema"));
            u.setJtable(rs.getString("jtable"));
            u.setImagen(rs.getString("imagen"));
            u.setIdRol(rs.getInt("idRol"));
            u.setCreatedAt(rs.getString("created_at"));
            u.setUpdatedAt(rs.getString("updated_at"));
            return u;
        });
    }

    public List<ListarUsuarioDTO> listarUsuarioss() {
        return this.jdbcTemplate.query("SELECT * FROM users", new Object[0], (rs, rowNum) -> {
            ListarUsuarioDTO u = new ListarUsuarioDTO();
            u.setId(rs.getInt("id"));
            u.setNombres(rs.getString("nombres"));
            u.setApellidos(rs.getString("apellidos"));
            u.setEmail(rs.getString("email"));
            u.setSuscripcion(rs.getInt("suscripcion"));
            u.setTema(rs.getString("tema"));
            u.setDni(rs.getString("dni"));
            u.setJtable(rs.getString("jtable"));
            u.setImagen(rs.getString("imagen"));
            u.setIdRol(rs.getInt("idRol"));
            u.setCreatedAt(rs.getString("created_at"));
            u.setUpdatedAt(rs.getString("updated_at"));
            return u;
        });
    }

    public void editarUsuario(EditarUsuarioDTO dto) {
        String sql = "CALL sp_editar_usuario(?, ?, ?, ?)";
        this.jdbcTemplate.update(sql, new Object[]{dto.getId(), dto.getNombres(), dto.getApellidos(), dto.getEmail()});
    }

    public void eliminarUsuario(Integer id) {
        this.jdbcTemplate.update("CALL sp_eliminar_usuario(?)", new Object[]{id});
    }

    public UsuarioDTO findByUsername(String hashedUsername) {
        String sql = "    SELECT id, nombres, email, idRol, suscripcion,\n           tema, jtable, imagen, password AS passwordHash, expirationToken, two_factor_enabled, secret_2fa\n    FROM users\n    WHERE username = ?\n";
        try {
            return (UsuarioDTO)this.jdbcTemplate.queryForObject("    SELECT id, nombres, email, idRol, suscripcion,\n           tema, jtable, imagen, password AS passwordHash, expirationToken, two_factor_enabled, secret_2fa\n    FROM users\n    WHERE username = ?\n", new Object[]{hashedUsername}, (rs, rowNum) -> {
                UsuarioDTO usuario = new UsuarioDTO();
                usuario.setId(Integer.valueOf(rs.getInt("id")));
                usuario.setNombres(rs.getString("nombres"));
                usuario.setEmail(rs.getString("email"));
                usuario.setRol(rs.getInt("idRol"));
                usuario.setSuscripcion(Integer.valueOf(rs.getInt("suscripcion")));
                usuario.setTema(rs.getString("tema"));
                usuario.setJTable(rs.getString("jtable"));
                usuario.setImagen(rs.getString("imagen"));
                usuario.setPasswordHash(rs.getString("passwordHash"));
                usuario.setExpirationToken((Date)rs.getTimestamp("expirationToken"));
                usuario.setTwoFactorEnabled(rs.getBoolean("two_factor_enabled"));
                usuario.setSecret2FA(rs.getString("secret_2fa"));
                return usuario;
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error al buscar usuario por username", e);
        }
    }

    public UsuarioDTO findByEmail(String email) {
        String sql = "    SELECT id, nombres, email, idRol, suscripcion,\n           tema, jtable, imagen, password AS passwordHash, expirationToken\n    FROM users\n    WHERE email = ?\n";
        try {
            return (UsuarioDTO)this.jdbcTemplate.queryForObject("    SELECT id, nombres, email, idRol, suscripcion,\n           tema, jtable, imagen, password AS passwordHash, expirationToken\n    FROM users\n    WHERE email = ?\n", new Object[]{email}, (rs, rowNum) -> {
                UsuarioDTO usuario = new UsuarioDTO();
                usuario.setId(Integer.valueOf(rs.getInt("id")));
                usuario.setNombres(rs.getString("nombres"));
                usuario.setEmail(rs.getString("email"));
                usuario.setRol(rs.getInt("idRol"));
                usuario.setSuscripcion(Integer.valueOf(rs.getInt("suscripcion")));
                usuario.setTema(rs.getString("tema"));
                usuario.setJTable(rs.getString("jtable"));
                usuario.setImagen(rs.getString("imagen"));
                usuario.setPasswordHash(rs.getString("passwordHash"));
                Timestamp timestamp = rs.getTimestamp("expirationToken");
                usuario.setExpirationToken((Date)timestamp);
                return usuario;
            });
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error al buscar usuario por email: " + email, e);
        }
    }

    public void actualizarExpirationToken(String username, Date expirationToken) {
        String sql = "UPDATE users SET expirationToken = ? WHERE username = ?";
        this.jdbcTemplate.update(sql, new Object[]{expirationToken, username});
    }

    public void actualizarPasswordPorEmail(String email, String password) {
        String sql = "UPDATE users SET password = ? WHERE email = ?";
        this.jdbcTemplate.update(sql, new Object[]{password, email});
    }

    public void removeExpirationToken(String username) {
        String sql = "UPDATE users SET expirationToken = ? WHERE username = ?";
        this.jdbcTemplate.update(sql, new Object[]{null, username});
    }

    public void actualizarExpirationTokenWithUserId(Integer userId, Date expirationToken) {
        String sql = "UPDATE users SET expirationToken = ? WHERE id = ?";
        this.jdbcTemplate.update(sql, new Object[]{expirationToken, userId});
    }

    @Transactional
    public void updateTwoFactorEnabled(String username, boolean enabled) {
        String sql = "UPDATE users SET two_factor_enabled = ? WHERE username = ?";
        this.jdbcTemplate.update(sql, new Object[]{enabled, username});
    }
}

