/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Security;

import Proyecto.MegaWeb2.__BackEnd.Service.AuditService;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class AuditInterceptor
extends OncePerRequestFilter {
    @Autowired(required=false)
    private AuditService auditService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String endpoint = request.getRequestURI();
        String metodo = request.getMethod();
        String ipAddress = this.obtenerIPCliente(request);
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (this.auditService != null && this.debeRegistrarse(endpoint, metodo)) {
                String usuario = (String)request.getAttribute("username");
                if (usuario == null) {
                    usuario = "ANONIMO";
                }
                if (!(endpoint.contains("/api/productos") || endpoint.contains("/api/clientes") || endpoint.contains("/swagger") || endpoint.contains("/v3/api-docs"))) {
                    this.auditService.registrarEvento(usuario, "API_CALL", metodo + " " + endpoint, ipAddress, endpoint, metodo);
                }
            }
        }
    }

    private boolean debeRegistrarse(String endpoint, String metodo) {
        return metodo.equals("POST") || metodo.equals("PUT") || metodo.equals("DELETE");
    }

    private String obtenerIPCliente(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null && !xForwardedFor.isEmpty()) {
            return xForwardedFor.split(",")[0].trim();
        }
        String xRealIp = request.getHeader("X-Real-IP");
        if (xRealIp != null && !xRealIp.isEmpty()) {
            return xRealIp;
        }
        return request.getRemoteAddr();
    }

    protected boolean shouldNotFilter(HttpServletRequest request) {
        String path = request.getRequestURI();
        return path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/images") || path.startsWith("/swagger-ui");
    }
}

