/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Security;

import Proyecto.MegaWeb2.__BackEnd.Security.JwtUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    private final JwtUtil jwtUtil;

    public JwtAuthenticationFilter(JwtUtil jwtUtil) {
        this.jwtUtil = jwtUtil;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith("Bearer ")) {
            String jwt = authHeader.substring(7);
            try {
                if (this.jwtUtil.isTokenValid(jwt)) {
                    String username = this.jwtUtil.extractUsername(jwt);
                    Integer idRol = this.jwtUtil.extractIdRol(jwt);
                    Integer idUsuario = this.jwtUtil.extractIdUsuario(jwt);
                    UsernamePasswordAuthenticationToken authToken = new UsernamePasswordAuthenticationToken((Object)username, null, Collections.singletonList(new SimpleGrantedAuthority("ROLE_" + idRol)));
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authToken);
                    request.setAttribute("idRol", (Object)idRol);
                    request.setAttribute("idUsuario", (Object)idUsuario);
                }
            }
            catch (Exception e) {
                System.out.println("JWT inv\u00e1lido o ausente: " + e.getMessage());
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

