/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Security;

import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Model.User;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil {
    private final SecretKey SECRET_KEY = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);

    public Map<String, Object> generateToken(UsuarioDTO user) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("id", user.getId());
        claims.put("nombres", user.getNombres());
        claims.put("apellidos", user.getApellidos());
        claims.put("idRol", user.getRol());
        long now = System.currentTimeMillis();
        long expiration = now + 360000L;
        String token = Jwts.builder().setClaims(claims).setSubject(user.getEmail()).setIssuedAt(new Date(now)).setExpiration(new Date(expiration)).signWith((Key)this.SECRET_KEY).compact();
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("token", token);
        response.put("expiration", expiration);
        return response;
    }

    public String generateTemporaryToken(String email, Duration duration) {
        Instant now = Instant.now();
        return Jwts.builder().setSubject(email).setIssuedAt(Date.from(now)).setExpiration(Date.from(now.plus(duration))).signWith((Key)this.SECRET_KEY).compact();
    }

    public String validarYObtenerEmail(String token) {
        try {
            Claims claims = (Claims)Jwts.parserBuilder().setSigningKey((Key)this.SECRET_KEY).build().parseClaimsJws(token).getBody();
            return claims.getSubject();
        }
        catch (JwtException e) {
            return null;
        }
    }

    public String generateToken(User user) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("id", user.getId());
        claims.put("username", user.getEmail());
        claims.put("nombres", user.getNombres());
        claims.put("apellidos", user.getApellidos());
        claims.put("idRol", user.getIdRol());
        long now = System.currentTimeMillis();
        long expiration = now + 360000L;
        return Jwts.builder().setClaims(claims).setSubject(user.getEmail()).setIssuedAt(new Date(now)).setExpiration(new Date(expiration)).signWith((Key)this.SECRET_KEY).compact();
    }

    public String extractUsername(String token) {
        return this.extractAllClaims(token).getSubject();
    }

    public Integer extractIdRol(String token) {
        Object claim = this.extractAllClaims(token).get((Object)"idRol");
        if (claim instanceof Integer) {
            return (Integer)claim;
        }
        if (claim instanceof Long) {
            return ((Long)claim).intValue();
        }
        return null;
    }

    public Integer extractIdUsuario(String token) {
        Object claim = this.extractAllClaims(token).get((Object)"id");
        if (claim instanceof Integer) {
            return (Integer)claim;
        }
        if (claim instanceof Long) {
            return ((Long)claim).intValue();
        }
        return null;
    }

    public boolean isTokenValid(String token) {
        try {
            Claims claims = this.extractAllClaims(token);
            return claims.getExpiration().after(new Date());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Claims extractAllClaims(String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey((Key)this.SECRET_KEY).build().parseClaimsJws(token).getBody();
    }
}

