/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import Proyecto.MegaWeb2.__BackEnd.Dto.AdminRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.AdminUpdateRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ListarAdminDTO;
import Proyecto.MegaWeb2.__BackEnd.Repository.AdminRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class AdminService {
    @Autowired
    private AdminRepository adminRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public int registrarAdministrador(AdminRequestDTO dto) {
        String hashedPassword = this.passwordEncoder.encode((CharSequence)dto.getPassword());
        dto.setPassword(hashedPassword);
        return this.adminRepository.crearAdministrador(dto);
    }

    public List<ListarAdminDTO> listarAdministradores() {
        return this.adminRepository.listarAdministradores();
    }

    public int editarAdministrador(AdminUpdateRequestDTO dto) {
        if (dto.getNuevaPassword() != null && !dto.getNuevaPassword().trim().isEmpty()) {
            if (dto.getPasswordActual() == null || dto.getConfirmarPassword() == null) {
                throw new RuntimeException("Debe proporcionar la contrase\u00f1a actual y confirmarla.");
            }
            String actualEncriptada = (String)this.jdbcTemplate.queryForObject("SELECT password FROM users WHERE id = ?", new Object[]{dto.getId()}, String.class);
            if (!this.passwordEncoder.matches((CharSequence)dto.getPasswordActual(), actualEncriptada)) {
                throw new RuntimeException("La contrase\u00f1a actual es incorrecta.");
            }
            if (!dto.getNuevaPassword().equals(dto.getConfirmarPassword())) {
                throw new RuntimeException("La nueva contrase\u00f1a y la confirmaci\u00f3n no coinciden.");
            }
            dto.setNuevaPassword(this.passwordEncoder.encode((CharSequence)dto.getNuevaPassword()));
        } else {
            dto.setNuevaPassword(null);
        }
        return this.adminRepository.editarAdministrador(dto);
    }

    public Integer eliminarUsuario(Integer id) {
        return this.adminRepository.eliminarUsuarioLogico(id);
    }
}

