/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import Proyecto.MegaWeb2.__BackEnd.Model.AuditLog;
import Proyecto.MegaWeb2.__BackEnd.Repository.AuditLogRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    @Autowired
    private AuditLogRepository auditLogRepository;

    public void registrarEvento(String usuario, String accion, String descripcion, String ipAddress, String endpoint, String metodoHttp) {
        AuditLog log = new AuditLog();
        log.setUsuario(usuario != null ? usuario : "ANONIMO");
        log.setAccion(accion);
        log.setDescripcion(descripcion);
        log.setFecha(LocalDateTime.now());
        log.setIpAddress(ipAddress);
        log.setEndpoint(endpoint);
        log.setMetodoHttp(metodoHttp);
        this.auditLogRepository.save((Object)log);
    }

    public void registrarLoginExitoso(String usuario, String ipAddress) {
        this.registrarEvento(usuario, "LOGIN", "Inicio de sesi\u00f3n exitoso", ipAddress, "/api/auth/login", "POST");
    }

    public void registrarLoginFallido(String usuario, String ipAddress, String razon) {
        this.registrarEvento(usuario, "LOGIN_FALLIDO", "Intento de login fallido: " + razon, ipAddress, "/api/auth/login", "POST");
    }

    public void registrarEliminacion(String usuarioAdmin, Integer idEliminado, String tipoEntidad, String ipAddress) {
        String descripcion = "Eliminado " + tipoEntidad + " ID: " + idEliminado;
        this.registrarEvento(usuarioAdmin, "ELIMINAR", descripcion, ipAddress, "/api/" + tipoEntidad.toLowerCase(), "DELETE");
    }

    public void registrarCambioPassword(String usuario, String ipAddress) {
        this.registrarEvento(usuario, "CAMBIO_PASSWORD", "Cambio de contrase\u00f1a", ipAddress, "/api/auth/cambiar-password", "PUT");
    }

    public void registrarAccesoRecurso(String usuario, String recurso, String ipAddress) {
        this.registrarEvento(usuario, "ACCESO_RECURSO", "Acceso a: " + recurso, ipAddress, recurso, "GET");
    }

    public void registrarDenegacionPermiso(String usuario, String recurso, String ipAddress) {
        this.registrarEvento(usuario, "PERMISO_DENEGADO", "Intento acceso denegado a: " + recurso, ipAddress, recurso, "GET");
    }

    public List<AuditLog> obtenerTodosLogs() {
        return this.auditLogRepository.findAllByOrderByFechaDesc();
    }

    public List<AuditLog> obtenerLogsPorUsuario(String usuario) {
        return this.auditLogRepository.findByUsuarioOrderByFechaDesc(usuario);
    }

    public List<AuditLog> obtenerLogsPorAccion(String accion) {
        return this.auditLogRepository.findByAccionOrderByFechaDesc(accion);
    }
}

