/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import Proyecto.MegaWeb2.__BackEnd.Config.CertificateConfig;
import Proyecto.MegaWeb2.__BackEnd.Security.JwtUtil;
import Proyecto.MegaWeb2.__BackEnd.Service.GeneradorCertificadoService;
import com.spire.pdf.PdfDocument;
import com.spire.pdf.graphics.PdfFont;
import com.spire.pdf.graphics.PdfFontBase;
import com.spire.pdf.graphics.PdfFontFamily;
import com.spire.pdf.graphics.PdfFontStyle;
import com.spire.pdf.graphics.PdfImage;
import com.spire.pdf.security.GraphicMode;
import com.spire.pdf.security.PdfCertificate;
import com.spire.pdf.security.PdfCertificationFlags;
import com.spire.pdf.security.PdfSignature;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
public class FirmaPdfService {
    private final CertificateConfig certConfig;
    private final GeneradorCertificadoService certificadoService;
    private final JwtUtil jwtUtil;
    @Value(value="${certificado.ruta-pfx:certificado_firma.pfx}")
    private String rutaPFX;
    @Value(value="${certificado.password:tuPasswordSeguro}")
    private String passwordCertificado;

    @Autowired
    public FirmaPdfService(CertificateConfig certConfig, GeneradorCertificadoService certificadoService, JwtUtil jwtUtil) {
        this.certConfig = certConfig;
        this.certificadoService = certificadoService;
        this.jwtUtil = jwtUtil;
    }

    public byte[] firmarPdf(byte[] archivoPdf, String token) throws Exception {
        if (!new File(this.rutaPFX).exists()) {
            this.certificadoService.generarCertificadoPFX(this.rutaPFX, this.passwordCertificado);
        }
        String nombreUsuario = this.jwtUtil.extractUsername(token);
        String nombres = (String)this.jwtUtil.extractAllClaims(token).get((Object)"nombres");
        String apellidos = (String)this.jwtUtil.extractAllClaims(token).get((Object)"apellidos");
        PdfDocument doc = new PdfDocument();
        doc.loadFromBytes(archivoPdf);
        PdfCertificate cert = new PdfCertificate(this.rutaPFX, this.passwordCertificado);
        for (int i = 0; i < doc.getPages().getCount(); ++i) {
            PdfSignature signature = new PdfSignature(doc, doc.getPages().get(i), cert, "MySignature_" + i);
            Rectangle2D.Float rect = new Rectangle2D.Float();
            rect.setFrame(new Point2D.Float((float)doc.getPages().get(i).getActualSize().getWidth() - 380.0f, (float)doc.getPages().get(i).getActualSize().getHeight() - 120.0f), new Dimension(350, 150));
            signature.setBounds((Rectangle2D)rect);
            signature.setGraphicMode(GraphicMode.Sign_Image_And_Sign_Detail);
            signature.setNameLabel("Nombres:");
            signature.setName(nombres);
            signature.setContactInfoLabel("Usuario:");
            signature.setContactInfo(nombreUsuario);
            signature.setDateLabel("Fecha:");
            signature.setDate(new Date());
            signature.setSignDetailsFont((PdfFontBase)new PdfFont(PdfFontFamily.Helvetica, 10.0f, PdfFontStyle.Bold));
            signature.setDocumentPermissions(PdfCertificationFlags.Forbid_Changes);
            signature.setCertificated(true);
            ClassPathResource resource = new ClassPathResource("static/firmas/firma.png");
            signature.setSignImageSource(PdfImage.fromFile((String)resource.getFile().getAbsolutePath()));
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        doc.saveToStream((OutputStream)outputStream);
        doc.close();
        return outputStream.toByteArray();
    }
}

