/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.springframework.stereotype.Service;

@Service
public class GeneradorCertificadoService {
    public void generarCertificadoPFX(String rutaPFX, String password) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate certificado = this.generarCertificadoAutofirmado(keyPair);
        KeyStore pkcs12 = KeyStore.getInstance("PKCS12", "BC");
        pkcs12.load(null, null);
        pkcs12.setKeyEntry("certificado-firma", keyPair.getPrivate(), password.toCharArray(), new Certificate[]{certificado});
        try (FileOutputStream fos = new FileOutputStream(rutaPFX);){
            pkcs12.store(fos, password.toCharArray());
        }
    }

    private X509Certificate generarCertificadoAutofirmado(KeyPair keyPair) throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGen.setIssuerDN(new X500Principal("CN=TuEmpresa, O=TuOrganizacion, C=PE"));
        certGen.setNotBefore(new Date(System.currentTimeMillis() - 86400000L));
        certGen.setNotAfter(new Date(System.currentTimeMillis() + 31536000000L));
        certGen.setSubjectDN(new X500Principal("CN=TuEmpresa, O=TuOrganizacion, C=PE"));
        certGen.setPublicKey(keyPair.getPublic());
        certGen.setSignatureAlgorithm("SHA256WithRSAEncryption");
        return certGen.generate(keyPair.getPrivate(), "BC");
    }
}

