/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import Proyecto.MegaWeb2.__BackEnd.Util.OtpEntry;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class OtpMemoryStore {
    private final Map<String, OtpEntry> otpMap = new ConcurrentHashMap();

    public void guardarCodigo(String email, String codigo) {
        String clave = email.trim().toLowerCase();
        this.otpMap.put(clave, new OtpEntry(codigo, LocalDateTime.now().plusMinutes(5L)));
    }

    public boolean verificarCodigo(String email, String codigoIngresado) {
        String clave = email.trim().toLowerCase();
        OtpEntry entry = (OtpEntry)this.otpMap.get(clave);
        if (entry == null) {
            return false;
        }
        if (LocalDateTime.now().isAfter(entry.getExpiracion())) {
            this.otpMap.remove(clave);
            return false;
        }
        boolean valido = entry.getCodigo().equals(codigoIngresado);
        if (valido) {
            this.otpMap.remove(clave);
        }
        return valido;
    }
}

