/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import Proyecto.MegaWeb2.__BackEnd.Service.TwoFactorService;
import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorKey;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.springframework.stereotype.Service;

@Service
public class TwoFactorService {
    private final GoogleAuthenticator gAuth = new GoogleAuthenticator();
    private final Map<String, CodigoTemporal> codigosCorreo = new HashMap();
    private final Random random = new Random();

    public String generateSecret() {
        GoogleAuthenticatorKey key = this.gAuth.createCredentials();
        return key.getKey();
    }

    public String getOtpAuthURL(String username, String secret) {
        String issuer = "MegaWeb";
        return String.format("otpauth://totp/%s:%s?secret=%s&issuer=%s", issuer, username, secret, issuer);
    }

    public boolean verifyCode(String secret, int code) {
        return this.gAuth.authorize(secret, code);
    }

    public String generarCodigo6Digitos(String email) {
        int numero = 100000 + this.random.nextInt(900000);
        String codigo = String.valueOf(numero);
        this.codigosCorreo.put(email, new CodigoTemporal(codigo, LocalDateTime.now().plusMinutes(5L)));
        return codigo;
    }

    public boolean validarCodigo(String email, String codigoIngresado) {
        CodigoTemporal ct = (CodigoTemporal)this.codigosCorreo.get(email);
        if (ct == null) {
            return false;
        }
        if (ct.getFechaExpiracion().isBefore(LocalDateTime.now())) {
            this.codigosCorreo.remove(email);
            return false;
        }
        boolean valido = ct.getCodigo().equals(codigoIngresado);
        if (valido) {
            this.codigosCorreo.remove(email);
        }
        return valido;
    }
}

