/*
 * Decompiled with CFR 0.152.
 */
package Proyecto.MegaWeb2.__BackEnd.Service;

import Proyecto.MegaWeb2.__BackEnd.Dto.EditarUsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.ListarUsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioCreateRequestDTO;
import Proyecto.MegaWeb2.__BackEnd.Dto.UsuarioDTO;
import Proyecto.MegaWeb2.__BackEnd.Model.User;
import Proyecto.MegaWeb2.__BackEnd.Repository.UsuarioRepository;
import com.spire.pdf.PdfDocument;
import com.spire.pdf.graphics.PdfImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UsuarioService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private UsuarioRepository usuarioRepository;
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();

    public UsuarioDTO authenticateByEmail(String email, String password) {
        User user = (User)this.jdbcTemplate.query("CALL sp_login(?)", new Object[]{email}, rs -> {
            if (rs.next()) {
                User u = new User();
                u.setId(rs.getInt("id"));
                u.setNombres(rs.getString("nombres"));
                u.setApellidos(rs.getString("apellidos"));
                u.setPassword(rs.getString("password"));
                u.setEmail(rs.getString("email"));
                u.setIdRol(rs.getInt("idRol"));
                u.setEstado(rs.getInt("estado"));
                return u;
            }
            return null;
        });
        if (user == null) {
            return null;
        }
        if (!this.passwordEncoder.matches((CharSequence)password, user.getPassword())) {
            return null;
        }
        UsuarioDTO dto = new UsuarioDTO();
        dto.setId(Integer.valueOf(user.getId()));
        dto.setNombres(user.getNombres());
        dto.setApellidos(user.getApellidos());
        dto.setEmail(user.getEmail());
        dto.setRol(user.getIdRol());
        dto.setEstado(user.getEstado());
        dto.setTwoFactorEnabled(false);
        return dto;
    }

    public int crearUsuario(UsuarioCreateRequestDTO dto) {
        dto.setPassword(this.passwordEncoder.encode((CharSequence)dto.getPassword()));
        int idUsuario = this.usuarioRepository.crearUsuario(dto);
        try {
            PdfDocument pdf = new PdfDocument();
            pdf.loadFromFile("plantilla_terminos.pdf");
            byte[] decodedImg = Base64.getDecoder().decode(dto.getFirmaBase64().split(",")[1]);
            ByteArrayInputStream bais = new ByteArrayInputStream(decodedImg);
            PdfImage pdfImg = PdfImage.fromStream((InputStream)bais);
            pdf.getPages().get(0).getCanvas().drawImage(pdfImg, 50.0f, 100.0f, 200.0f, 100.0f);
            String outputPdf = "usuario_" + idUsuario + "_firmado.pdf";
            pdf.saveToFile(outputPdf);
            pdf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return idUsuario;
    }

    public List<ListarUsuarioDTO> listarUsuarios(Integer id) {
        return this.usuarioRepository.listarUsuarios(id);
    }

    public void editarUsuario(EditarUsuarioDTO dto) {
        this.usuarioRepository.editarUsuario(dto);
    }

    public void eliminarUsuario(Integer id) {
        this.usuarioRepository.eliminarUsuario(id);
    }

    public void updatePassword(String email, String nuevaPassword) {
        String hashedPassword = this.passwordEncoder.encode((CharSequence)nuevaPassword);
        this.usuarioRepository.actualizarPasswordPorEmail(email, hashedPassword);
    }

    public UsuarioDTO findByEmail(String email) {
        return this.usuarioRepository.findByEmail(email);
    }

    public void updateSecret2FA(String email, String secret2FA) {
        this.usuarioRepository.updateSecret2FA(email, secret2FA);
    }

    public boolean verify2FACode(String codigoIngresado) {
        String sql = "SELECT COUNT(*) FROM users WHERE secret_2fa = ?";
        Integer count = (Integer)this.jdbcTemplate.queryForObject(sql, new Object[]{codigoIngresado}, Integer.class);
        return count != null && count > 0;
    }

    public void updateTwoFactorEnabled(String email, boolean enabled) {
        this.usuarioRepository.updateTwoFactorEnabled(email, enabled);
    }

    public void updateExpirationToken(String email, Date expirationToken) {
        this.usuarioRepository.actualizarExpirationToken(email, expirationToken);
    }

    public void removeExpirationToken(String email) {
        this.usuarioRepository.removeExpirationToken(email);
    }

    public void updateExpirationTokenWithUserId(Integer userId, Date expirationToken) {
        this.usuarioRepository.actualizarExpirationTokenWithUserId(userId, expirationToken);
    }
}

