/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin"})
@Tag(name="Administraci\u00f3n", description="Endpoints para administraci\u00f3n del sistema")
public class AdminController {
    private static final Logger log = LoggerFactory.getLogger(AdminController.class);

    @GetMapping(value={"/dashboard"})
    @PreAuthorize(value="hasRole('SUPERADMINISTRADOR')")
    @Operation(summary="Dashboard administrativo", description="Panel de control para superadministradores")
    public ResponseEntity<Map<String, Object>> dashboard() {
        try {
            log.info("Accediendo al dashboard administrativo");
            HashMap<String, Object> dashboard = new HashMap<String, Object>();
            dashboard.put("titulo", "Dashboard Administrativo");
            dashboard.put("descripcion", "Panel de control del sistema");
            dashboard.put("usuario", "Superadministrador");
            dashboard.put("modulos", new String[]{"Usuarios", "Empresas", "Reportes", "Configuraci\u00f3n"});
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Dashboard cargado exitosamente");
            response.put("data", dashboard);
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Error al cargar dashboard administrativo", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }
}

