/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.LoginRequest;
import com.sistema.turistico.dto.LoginResponse;
import com.sistema.turistico.dto.LogoutRequest;
import com.sistema.turistico.dto.RegisterRequest;
import com.sistema.turistico.entity.Permiso;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.repository.UsuarioRepository;
import com.sistema.turistico.security.AuthenticatedUser;
import com.sistema.turistico.service.UsuarioService;
import com.sistema.turistico.util.JwtUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
@Tag(name="Autenticaci\u00f3n", description="Endpoints para autenticaci\u00f3n y gesti\u00f3n de usuarios")
public class AuthController {
    private static final Logger log = LoggerFactory.getLogger(AuthController.class);
    private final AuthenticationManager authenticationManager;
    private final UsuarioRepository usuarioRepository;
    private final JwtUtil jwtUtil;
    private final UsuarioService usuarioService;

    @PostMapping(value={"/login"})
    @Operation(summary="Iniciar sesi\u00f3n", description="Autentica al usuario y devuelve un token JWT")
    public ResponseEntity<LoginResponse> login(@Valid @RequestBody LoginRequest loginRequest) {
        try {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)loginRequest.getEmail(), (Object)loginRequest.getPassword()));
            Usuario usuario = (Usuario)this.usuarioRepository.findByEmailWithRolAndEmpresa(loginRequest.getEmail()).orElseThrow(() -> new RuntimeException("Usuario no encontrado"));
            List roles = authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).collect(Collectors.toList());
            String token = this.ensurePersistentToken(usuario, roles);
            List permisos = usuario.getRol().getPermisos().stream().map(Permiso::getNombrePermiso).collect(Collectors.toList());
            LoginResponse response = new LoginResponse(token, usuario.getIdUsuario(), usuario.getEmail(), usuario.getNombre(), usuario.getApellido(), usuario.getRol().getNombreRol(), usuario.getEmpresa().getIdEmpresa(), usuario.getEmpresa().getNombreEmpresa(), permisos);
            usuario.setUltimoLogin(LocalDateTime.now());
            this.usuarioRepository.save((Object)usuario);
            return ResponseEntity.ok((Object)response);
        }
        catch (Exception e) {
            log.error("Error en login para usuario: {}", (Object)loginRequest.getEmail(), (Object)e);
            return ResponseEntity.badRequest().build();
        }
    }

    @PostMapping(value={"/register"})
    @Operation(summary="Registrar usuario", description="Registra un nuevo usuario en el sistema con rol Superadministrador por defecto")
    public ResponseEntity<LoginResponse> register(@Valid @RequestBody RegisterRequest registerRequest) {
        try {
            log.info("Registrando usuario: {}", (Object)registerRequest.getEmail());
            this.usuarioService.registrarUsuario(registerRequest);
            Usuario usuario = (Usuario)this.usuarioRepository.findByEmailWithRolAndEmpresa(registerRequest.getEmail()).orElseThrow(() -> new RuntimeException("Usuario no encontrado despu\u00e9s del registro"));
            List<String> roles = List.of(usuario.getRol().getNombreRol());
            List permisos = usuario.getRol().getPermisos().stream().map(Permiso::getNombrePermiso).collect(Collectors.toList());
            String token = this.ensurePersistentToken(usuario, roles);
            usuario.setUltimoLogin(LocalDateTime.now());
            this.usuarioRepository.save((Object)usuario);
            LoginResponse response = new LoginResponse(token, usuario.getIdUsuario(), usuario.getEmail(), usuario.getNombre(), usuario.getApellido(), usuario.getRol().getNombreRol(), usuario.getEmpresa().getIdEmpresa(), usuario.getEmpresa().getNombreEmpresa(), permisos);
            return ResponseEntity.ok((Object)response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error en registro para usuario: {} - {}", (Object)registerRequest.getEmail(), (Object)e.getMessage());
            return ResponseEntity.badRequest().build();
        }
        catch (Exception e) {
            log.error("Error inesperado en registro para usuario: {}", (Object)registerRequest.getEmail(), (Object)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    @PostMapping(value={"/logout"})
    @Operation(summary="Cerrar sesi\u00f3n", description="Invalida el token del usuario especificado mediante el body")
    public ResponseEntity<Void> logout(@RequestBody LogoutRequest request) {
        try {
            Usuario usuario = (Usuario)this.usuarioRepository.findById((Object)request.getId()).orElseThrow(() -> new RuntimeException("Usuario no encontrado"));
            if ("".equals(request.getToken())) {
                usuario.setToken(null);
                this.usuarioRepository.save((Object)usuario);
                log.debug("Token invalidado para el usuario {}", (Object)usuario.getEmail());
            }
            return ResponseEntity.ok().build();
        }
        catch (Exception e) {
            log.error("Error en logout para usuario id: {}", (Object)request.getId(), (Object)e);
            return ResponseEntity.badRequest().build();
        }
    }

    private String ensurePersistentToken(Usuario usuario, List<String> roles) {
        String currentToken = usuario.getToken();
        if (currentToken != null && this.jwtUtil.isTokenValidForUser(currentToken, usuario.getEmail())) {
            return currentToken;
        }
        String newToken = this.jwtUtil.generateToken(usuario.getEmail(), roles, usuario.getIdUsuario(), usuario.getEmpresa().getIdEmpresa());
        usuario.setToken(newToken);
        return newToken;
    }

    private Optional<Usuario> resolveAuthenticatedUsuario(Authentication authentication) {
        if (authentication == null || !authentication.isAuthenticated()) {
            return Optional.empty();
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof AuthenticatedUser) {
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)principal;
            return this.usuarioRepository.findById((Object)authenticatedUser.getUserId()).or(() -> this.usuarioRepository.findByEmail(authentication.getName()));
        }
        String username = authentication.getName();
        if (username != null) {
            return this.usuarioRepository.findByEmail(username);
        }
        return Optional.empty();
    }

    public AuthController(AuthenticationManager authenticationManager, UsuarioRepository usuarioRepository, JwtUtil jwtUtil, UsuarioService usuarioService) {
        this.authenticationManager = authenticationManager;
        this.usuarioRepository = usuarioRepository;
        this.jwtUtil = jwtUtil;
        this.usuarioService = usuarioService;
    }
}

