/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.entity.EvaluacionServicio;
import com.sistema.turistico.service.EvaluacionServicioService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/evaluaciones"})
@Tag(name="Evaluaciones de Servicio", description="Gesti\u00f3n de evaluaciones de servicios por clientes")
public class EvaluacionServicioController {
    private static final Logger log = LoggerFactory.getLogger(EvaluacionServicioController.class);
    private final EvaluacionServicioService evaluacionService;

    @PostMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Crear evaluaci\u00f3n", description="Crea una nueva evaluaci\u00f3n de servicio")
    public ResponseEntity<Map<String, Object>> crearEvaluacion(@Valid @RequestBody EvaluacionServicio evaluacion) {
        try {
            EvaluacionServicio nuevaEvaluacion = this.evaluacionService.create(evaluacion);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaci\u00f3n creada exitosamente");
            response.put("data", nuevaEvaluacion);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al crear evaluaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al crear evaluaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Obtener evaluaci\u00f3n", description="Obtiene una evaluaci\u00f3n espec\u00edfica por ID")
    public ResponseEntity<Map<String, Object>> obtenerEvaluacion(@PathVariable Long id) {
        try {
            EvaluacionServicio evaluacion = (EvaluacionServicio)this.evaluacionService.findById(id).orElseThrow(() -> new IllegalArgumentException("Evaluaci\u00f3n no encontrada"));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaci\u00f3n obtenida exitosamente");
            response.put("data", evaluacion);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Evaluaci\u00f3n no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception ex) {
            log.error("Error al obtener evaluaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/reserva/{reservaId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Evaluaci\u00f3n por reserva", description="Obtiene la evaluaci\u00f3n de una reserva espec\u00edfica")
    public ResponseEntity<Map<String, Object>> obtenerPorReserva(@PathVariable Long reservaId) {
        try {
            EvaluacionServicio evaluacion = (EvaluacionServicio)this.evaluacionService.findByReservaId(reservaId).orElseThrow(() -> new IllegalArgumentException("No existe evaluaci\u00f3n para esta reserva"));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaci\u00f3n obtenida exitosamente");
            response.put("data", evaluacion);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Evaluaci\u00f3n no encontrada: {}", (Object)ex.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception ex) {
            log.error("Error al obtener evaluaci\u00f3n por reserva", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/cliente/{clienteId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Evaluaciones por cliente", description="Lista todas las evaluaciones de un cliente")
    public ResponseEntity<Map<String, Object>> listarPorCliente(@PathVariable Long clienteId) {
        try {
            List evaluaciones = this.evaluacionService.findByClienteId(clienteId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaciones obtenidas exitosamente");
            response.put("data", evaluaciones);
            response.put("total", evaluaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar evaluaciones por cliente", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/servicio/{servicioId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Evaluaciones por servicio", description="Lista todas las evaluaciones de un servicio")
    public ResponseEntity<Map<String, Object>> listarPorServicio(@PathVariable Long servicioId) {
        try {
            List evaluaciones = this.evaluacionService.findByServicioId(servicioId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaciones obtenidas exitosamente");
            response.put("data", evaluaciones);
            response.put("total", evaluaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar evaluaciones por servicio", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/paquete/{paqueteId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Evaluaciones por paquete", description="Lista todas las evaluaciones de un paquete tur\u00edstico")
    public ResponseEntity<Map<String, Object>> listarPorPaquete(@PathVariable Long paqueteId) {
        try {
            List evaluaciones = this.evaluacionService.findByPaqueteId(paqueteId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaciones obtenidas exitosamente");
            response.put("data", evaluaciones);
            response.put("total", evaluaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar evaluaciones por paquete", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/calificacion/{calificacion}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Evaluaciones por calificaci\u00f3n", description="Lista evaluaciones con una calificaci\u00f3n espec\u00edfica")
    public ResponseEntity<Map<String, Object>> listarPorCalificacion(@PathVariable Integer calificacion) {
        try {
            List evaluaciones = this.evaluacionService.findByCalificacionGeneral(calificacion);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaciones obtenidas exitosamente");
            response.put("data", evaluaciones);
            response.put("total", evaluaciones.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar evaluaciones por calificaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Actualizar evaluaci\u00f3n", description="Actualiza los datos de una evaluaci\u00f3n existente")
    public ResponseEntity<Map<String, Object>> actualizarEvaluacion(@PathVariable Long id, @RequestBody EvaluacionServicio evaluacion) {
        try {
            EvaluacionServicio evaluacionActualizada = this.evaluacionService.update(id, evaluacion);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaci\u00f3n actualizada exitosamente");
            response.put("data", evaluacionActualizada);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar evaluaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al actualizar evaluaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/{id}/estado"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Cambiar estado evaluaci\u00f3n", description="Oculta o muestra una evaluaci\u00f3n (soft delete)")
    public ResponseEntity<Map<String, Object>> cambiarEstadoEvaluacion(@PathVariable Long id) {
        try {
            EvaluacionServicio evaluacion = this.evaluacionService.toggleEstado(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Estado de evaluaci\u00f3n cambiado exitosamente");
            response.put("data", evaluacion);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al cambiar estado de evaluaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al cambiar estado de evaluaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Eliminar evaluaci\u00f3n", description="Elimina una evaluaci\u00f3n del sistema")
    public ResponseEntity<Map<String, Object>> eliminarEvaluacion(@PathVariable Long id) {
        try {
            this.evaluacionService.delete(id);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Evaluaci\u00f3n eliminada exitosamente");
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al eliminar evaluaci\u00f3n: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al eliminar evaluaci\u00f3n", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/estadisticas/servicio/{servicioId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Estad\u00edsticas por servicio", description="Obtiene estad\u00edsticas de calificaciones para un servicio")
    public ResponseEntity<Map<String, Object>> obtenerEstadisticasServicio(@PathVariable Long servicioId) {
        try {
            Object[] estadisticas = this.evaluacionService.getEstadisticasByServicio(servicioId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Estad\u00edsticas obtenidas exitosamente");
            response.put("data", Map.of("servicioId", servicioId, "promedioCalificacion", estadisticas[0], "totalEvaluaciones", estadisticas[1]));
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al obtener estad\u00edsticas de servicio", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/estadisticas/paquete/{paqueteId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Estad\u00edsticas por paquete", description="Obtiene estad\u00edsticas de calificaciones para un paquete")
    public ResponseEntity<Map<String, Object>> obtenerEstadisticasPaquete(@PathVariable Long paqueteId) {
        try {
            Object[] estadisticas = this.evaluacionService.getEstadisticasByPaquete(paqueteId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Estad\u00edsticas obtenidas exitosamente");
            response.put("data", Map.of("paqueteId", paqueteId, "promedioCalificacion", estadisticas[0], "totalEvaluaciones", estadisticas[1]));
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al obtener estad\u00edsticas de paquete", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/puede-evaluar/{reservaId}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Verificar si puede evaluar", description="Verifica si una reserva puede ser evaluada")
    public ResponseEntity<Map<String, Object>> puedeEvaluarReserva(@PathVariable Long reservaId) {
        try {
            boolean puedeEvaluar = this.evaluacionService.puedeEvaluarReserva(reservaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Verificaci\u00f3n realizada exitosamente");
            response.put("data", Map.of("reservaId", reservaId, "puedeEvaluar", puedeEvaluar));
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al verificar si puede evaluar reserva", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public EvaluacionServicioController(EvaluacionServicioService evaluacionService) {
        this.evaluacionService = evaluacionService;
    }
}

