/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.PagoReservaRequest;
import com.sistema.turistico.entity.PagoReserva;
import com.sistema.turistico.service.PagoReservaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Pagos de Reserva", description="Gesti\u00f3n de pagos y devoluciones")
public class PagoReservaController {
    private static final Logger log = LoggerFactory.getLogger(PagoReservaController.class);
    private final PagoReservaService pagoReservaService;

    @PostMapping(value={"/reservas/{reservaId}/pagos"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Registrar pago", description="Registra un pago parcial o total para una reserva")
    public ResponseEntity<Map<String, Object>> registrarPago(@PathVariable Long reservaId, @Valid @RequestBody PagoReservaRequest request) {
        try {
            PagoReserva pago = this.pagoReservaService.registrarPago(reservaId, request);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Pago registrado correctamente");
            HashMap<String, Object> pagoData = new HashMap<String, Object>();
            pagoData.put("idPago", pago.getIdPago());
            pagoData.put("idReserva", pago.getReserva().getIdReserva());
            pagoData.put("idUsuario", pago.getUsuario().getIdUsuario());
            pagoData.put("montoPagado", pago.getMontoPagado());
            pagoData.put("metodoPago", pago.getMetodoPago());
            pagoData.put("numeroOperacion", pago.getNumeroOperacion());
            pagoData.put("comprobante", pago.getComprobante());
            pagoData.put("fechaPago", pago.getFechaPago());
            pagoData.put("observaciones", pago.getObservaciones());
            pagoData.put("estado", pago.getEstado());
            pagoData.put("createdAt", pago.getCreatedAt());
            pagoData.put("updatedAt", pago.getUpdatedAt());
            response.put("data", pagoData);
            response.put("saldoPendiente", this.pagoReservaService.obtenerSaldoPendiente(reservaId));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al registrar pago: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al registrar pago", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/reservas/{reservaId}/pagos"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Listar pagos de reserva", description="Obtiene el historial de pagos de una reserva")
    public ResponseEntity<Map<String, Object>> listarPagosReserva(@PathVariable Long reservaId) {
        try {
            List pagos = this.pagoReservaService.listarPagosReserva(reservaId);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Pagos obtenidos correctamente");
            List<Map> pagosData = pagos.stream().map(pago -> {
                HashMap<String, Object> pagoData = new HashMap<String, Object>();
                pagoData.put("idPago", pago.getIdPago());
                pagoData.put("idReserva", pago.getReserva().getIdReserva());
                pagoData.put("idUsuario", pago.getUsuario().getIdUsuario());
                pagoData.put("montoPagado", pago.getMontoPagado());
                pagoData.put("metodoPago", pago.getMetodoPago());
                pagoData.put("numeroOperacion", pago.getNumeroOperacion());
                pagoData.put("comprobante", pago.getComprobante());
                pagoData.put("fechaPago", pago.getFechaPago());
                pagoData.put("observaciones", pago.getObservaciones());
                pagoData.put("estado", pago.getEstado());
                pagoData.put("createdAt", pago.getCreatedAt());
                pagoData.put("updatedAt", pago.getUpdatedAt());
                return pagoData;
            }).toList();
            response.put("data", pagosData);
            response.put("total", pagos.size());
            response.put("saldoPendiente", this.pagoReservaService.obtenerSaldoPendiente(reservaId));
            return ResponseEntity.ok(response);
        }
        catch (Exception ex) {
            log.error("Error al listar pagos de reserva", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @DeleteMapping(value={"/reservas/{reservaId}/pagos/{pagoId}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Anular pago", description="Anula un pago previamente registrado")
    public ResponseEntity<Map<String, Object>> anularPago(@PathVariable Long reservaId, @PathVariable Long pagoId, @RequestParam Long cajaId, @RequestParam(required=false) String motivo) {
        try {
            PagoReserva pago = this.pagoReservaService.anularPago(reservaId, pagoId, cajaId, motivo);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Pago anulado correctamente");
            HashMap<String, Object> pagoData = new HashMap<String, Object>();
            pagoData.put("idPago", pago.getIdPago());
            pagoData.put("idReserva", pago.getReserva().getIdReserva());
            pagoData.put("idUsuario", pago.getUsuario().getIdUsuario());
            pagoData.put("montoPagado", pago.getMontoPagado());
            pagoData.put("metodoPago", pago.getMetodoPago());
            pagoData.put("numeroOperacion", pago.getNumeroOperacion());
            pagoData.put("comprobante", pago.getComprobante());
            pagoData.put("fechaPago", pago.getFechaPago());
            pagoData.put("observaciones", pago.getObservaciones());
            pagoData.put("estado", pago.getEstado());
            pagoData.put("createdAt", pago.getCreatedAt());
            pagoData.put("updatedAt", pago.getUpdatedAt());
            response.put("data", pagoData);
            response.put("saldoPendiente", this.pagoReservaService.obtenerSaldoPendiente(reservaId));
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            log.warn("Error al anular pago: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error inesperado al anular pago", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/pagos/{id}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Obtener pago espec\u00edfico", description="Obtiene un pago por su ID")
    public ResponseEntity<Map<String, Object>> obtenerPago(@PathVariable Long id) {
        try {
            PagoReserva pago = this.pagoReservaService.obtenerPago(id);
            HashMap<String, Object> pagoData = new HashMap<String, Object>();
            pagoData.put("idPago", pago.getIdPago());
            pagoData.put("idReserva", pago.getReserva().getIdReserva());
            pagoData.put("idUsuario", pago.getUsuario().getIdUsuario());
            pagoData.put("montoPagado", pago.getMontoPagado());
            pagoData.put("metodoPago", pago.getMetodoPago());
            pagoData.put("numeroOperacion", pago.getNumeroOperacion());
            pagoData.put("comprobante", pago.getComprobante());
            pagoData.put("fechaPago", pago.getFechaPago());
            pagoData.put("observaciones", pago.getObservaciones());
            pagoData.put("estado", pago.getEstado());
            pagoData.put("createdAt", pago.getCreatedAt());
            pagoData.put("updatedAt", pago.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Pago obtenido correctamente");
            response.put("data", pagoData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Pago no encontrado: {}", (Object)ex.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception ex) {
            log.error("Error al obtener pago", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @PutMapping(value={"/pagos/{id}"})
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Actualizar pago", description="Actualiza informaci\u00f3n de un pago")
    public ResponseEntity<Map<String, Object>> actualizarPago(@PathVariable Long id, @Valid @RequestBody PagoReservaRequest request) {
        try {
            PagoReserva pago = this.pagoReservaService.actualizarPago(id, request);
            HashMap<String, Object> pagoData = new HashMap<String, Object>();
            pagoData.put("idPago", pago.getIdPago());
            pagoData.put("idReserva", pago.getReserva().getIdReserva());
            pagoData.put("idUsuario", pago.getUsuario().getIdUsuario());
            pagoData.put("montoPagado", pago.getMontoPagado());
            pagoData.put("metodoPago", pago.getMetodoPago());
            pagoData.put("numeroOperacion", pago.getNumeroOperacion());
            pagoData.put("comprobante", pago.getComprobante());
            pagoData.put("fechaPago", pago.getFechaPago());
            pagoData.put("observaciones", pago.getObservaciones());
            pagoData.put("estado", pago.getEstado());
            pagoData.put("createdAt", pago.getCreatedAt());
            pagoData.put("updatedAt", pago.getUpdatedAt());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Pago actualizado correctamente");
            response.put("data", pagoData);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al actualizar pago: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al actualizar pago", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    @GetMapping(value={"/pagos"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Listar pagos", description="Listar pagos aplicando filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarPagos(@RequestParam(required=false) Long empresaId, @RequestParam(required=false) String metodoPago, @RequestParam(required=false) Boolean estado, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaDesde, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaHasta) {
        try {
            List pagos = this.pagoReservaService.listarPagosPorFiltros(empresaId, metodoPago, estado, fechaDesde, fechaHasta);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Pagos obtenidos correctamente");
            List<Map> pagosData = pagos.stream().map(pago -> {
                HashMap<String, Object> pagoData = new HashMap<String, Object>();
                pagoData.put("idPago", pago.getIdPago());
                pagoData.put("idReserva", pago.getReserva().getIdReserva());
                pagoData.put("idUsuario", pago.getUsuario().getIdUsuario());
                pagoData.put("montoPagado", pago.getMontoPagado());
                pagoData.put("metodoPago", pago.getMetodoPago());
                pagoData.put("numeroOperacion", pago.getNumeroOperacion());
                pagoData.put("comprobante", pago.getComprobante());
                pagoData.put("fechaPago", pago.getFechaPago());
                pagoData.put("observaciones", pago.getObservaciones());
                pagoData.put("estado", pago.getEstado());
                pagoData.put("createdAt", pago.getCreatedAt());
                pagoData.put("updatedAt", pago.getUpdatedAt());
                return pagoData;
            }).toList();
            response.put("data", pagosData);
            response.put("total", pagos.size());
            HashMap<String, Object> filtros = new HashMap<String, Object>();
            filtros.put("empresaId", empresaId);
            filtros.put("metodoPago", metodoPago);
            filtros.put("estado", estado);
            filtros.put("fechaDesde", fechaDesde);
            filtros.put("fechaHasta", fechaHasta);
            response.put("filtros", filtros);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Error al listar pagos: {}", (Object)ex.getMessage());
            return ResponseEntity.badRequest().body(Map.of("success", false, "message", ex.getMessage()));
        }
        catch (Exception ex) {
            log.error("Error al listar pagos", (Throwable)ex);
            return ResponseEntity.internalServerError().body(Map.of("success", false, "message", "Error interno del servidor"));
        }
    }

    public PagoReservaController(PagoReservaService pagoReservaService) {
        this.pagoReservaService = pagoReservaService;
    }
}

