/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Empresa;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.sql.Date;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="clientes", indexes={@Index(name="idx_clientes_empresa", columnList="id_empresa"), @Index(name="idx_clientes_email", columnList="email"), @Index(name="idx_clientes_dni", columnList="dni")})
public class Cliente {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_cliente")
    private Long idCliente;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @NotBlank(message="El nombre es obligatorio")
    @Size(max=100, message="El nombre no puede exceder 100 caracteres")
    @Column(name="nombre", nullable=false, length=100)
    private @NotBlank(message="El nombre es obligatorio") @Size(max=100, message="El nombre no puede exceder 100 caracteres") String nombre;
    @NotBlank(message="El apellido es obligatorio")
    @Size(max=100, message="El apellido no puede exceder 100 caracteres")
    @Column(name="apellido", nullable=false, length=100)
    private @NotBlank(message="El apellido es obligatorio") @Size(max=100, message="El apellido no puede exceder 100 caracteres") String apellido;
    @Email(message="El email debe tener un formato v\u00e1lido")
    @Size(max=255, message="El email no puede exceder 255 caracteres")
    @Column(name="email", length=255)
    private @Email(message="El email debe tener un formato v\u00e1lido") @Size(max=255, message="El email no puede exceder 255 caracteres") String email;
    @Column(name="email_encriptado", columnDefinition="VARBINARY(255)")
    private byte[] emailEncriptado;
    @Pattern(regexp="^[0-9]{9}$", message="El tel\u00e9fono debe tener 9 d\u00edgitos")
    @Column(name="telefono", length=20)
    private @Pattern(regexp="^[0-9]{9}$", message="El tel\u00e9fono debe tener 9 d\u00edgitos") String telefono;
    @Column(name="telefono_encriptado", columnDefinition="VARBINARY(255)")
    private byte[] telefonoEncriptado;
    @Size(max=20, message="El DNI no puede exceder 20 caracteres")
    @Column(name="dni", length=20)
    private @Size(max=20, message="El DNI no puede exceder 20 caracteres") String dni;
    @Past(message="La fecha de nacimiento debe ser anterior a la fecha actual")
    @Column(name="fecha_nacimiento")
    private @Past(message="La fecha de nacimiento debe ser anterior a la fecha actual") Date fechaNacimiento;
    @Size(max=100, message="La nacionalidad no puede exceder 100 caracteres")
    @Column(name="nacionalidad", length=100)
    private @Size(max=100, message="La nacionalidad no puede exceder 100 caracteres") String nacionalidad;
    @Column(name="preferencias_viaje", columnDefinition="TEXT")
    private String preferenciasViaje;
    @Min(value=0L, message="Los puntos de fidelizaci\u00f3n no pueden ser negativos")
    @Column(name="puntos_fidelizacion", nullable=false, columnDefinition="INT DEFAULT 0")
    private @Min(value=0L, message="Los puntos de fidelizaci\u00f3n no pueden ser negativos") Integer puntosFidelizacion = 0;
    @NotNull(message="El nivel de membres\u00eda es obligatorio")
    @Enumerated(value=EnumType.STRING)
    @Column(name="nivel_membresia", nullable=false, columnDefinition="ENUM('Bronce','Plata','Oro','Platino') DEFAULT 'Bronce'")
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="El nivel de membres\u00eda es obligatorio") Cliente.NivelMembresia nivelMembresia = NivelMembresia.Bronce;
    @NotNull(message="El estado es obligatorio")
    @Column(name="estado", nullable=false, columnDefinition="TINYINT(1) DEFAULT 1")
    private @NotNull(message="El estado es obligatorio") Boolean estado = true;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;

    public String getNombreCompleto() {
        return this.nombre + " " + this.apellido;
    }

    public boolean isActivo() {
        return this.estado != false && this.deletedAt == null;
    }

    public Long getIdCliente() {
        return this.idCliente;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public String getNombre() {
        return this.nombre;
    }

    public String getApellido() {
        return this.apellido;
    }

    public String getEmail() {
        return this.email;
    }

    public byte[] getEmailEncriptado() {
        return this.emailEncriptado;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public byte[] getTelefonoEncriptado() {
        return this.telefonoEncriptado;
    }

    public String getDni() {
        return this.dni;
    }

    public Date getFechaNacimiento() {
        return this.fechaNacimiento;
    }

    public String getNacionalidad() {
        return this.nacionalidad;
    }

    public String getPreferenciasViaje() {
        return this.preferenciasViaje;
    }

    public Integer getPuntosFidelizacion() {
        return this.puntosFidelizacion;
    }

    public NivelMembresia getNivelMembresia() {
        return this.nivelMembresia;
    }

    public Boolean getEstado() {
        return this.estado;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    public void setIdCliente(Long idCliente) {
        this.idCliente = idCliente;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    public void setApellido(String apellido) {
        this.apellido = apellido;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setEmailEncriptado(byte[] emailEncriptado) {
        this.emailEncriptado = emailEncriptado;
    }

    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    public void setTelefonoEncriptado(byte[] telefonoEncriptado) {
        this.telefonoEncriptado = telefonoEncriptado;
    }

    public void setDni(String dni) {
        this.dni = dni;
    }

    public void setFechaNacimiento(Date fechaNacimiento) {
        this.fechaNacimiento = fechaNacimiento;
    }

    public void setNacionalidad(String nacionalidad) {
        this.nacionalidad = nacionalidad;
    }

    public void setPreferenciasViaje(String preferenciasViaje) {
        this.preferenciasViaje = preferenciasViaje;
    }

    public void setPuntosFidelizacion(Integer puntosFidelizacion) {
        this.puntosFidelizacion = puntosFidelizacion;
    }

    public void setNivelMembresia(NivelMembresia nivelMembresia) {
        this.nivelMembresia = nivelMembresia;
    }

    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cliente)) {
            return false;
        }
        Cliente other = (Cliente)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idCliente = this.getIdCliente();
        Long other$idCliente = other.getIdCliente();
        if (this$idCliente == null ? other$idCliente != null : !((Object)this$idCliente).equals(other$idCliente)) {
            return false;
        }
        Integer this$puntosFidelizacion = this.getPuntosFidelizacion();
        Integer other$puntosFidelizacion = other.getPuntosFidelizacion();
        if (this$puntosFidelizacion == null ? other$puntosFidelizacion != null : !((Object)this$puntosFidelizacion).equals(other$puntosFidelizacion)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        String this$nombre = this.getNombre();
        String other$nombre = other.getNombre();
        if (this$nombre == null ? other$nombre != null : !this$nombre.equals(other$nombre)) {
            return false;
        }
        String this$apellido = this.getApellido();
        String other$apellido = other.getApellido();
        if (this$apellido == null ? other$apellido != null : !this$apellido.equals(other$apellido)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        if (!Arrays.equals(this.getEmailEncriptado(), other.getEmailEncriptado())) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        if (!Arrays.equals(this.getTelefonoEncriptado(), other.getTelefonoEncriptado())) {
            return false;
        }
        String this$dni = this.getDni();
        String other$dni = other.getDni();
        if (this$dni == null ? other$dni != null : !this$dni.equals(other$dni)) {
            return false;
        }
        Date this$fechaNacimiento = this.getFechaNacimiento();
        Date other$fechaNacimiento = other.getFechaNacimiento();
        if (this$fechaNacimiento == null ? other$fechaNacimiento != null : !((Object)this$fechaNacimiento).equals(other$fechaNacimiento)) {
            return false;
        }
        String this$nacionalidad = this.getNacionalidad();
        String other$nacionalidad = other.getNacionalidad();
        if (this$nacionalidad == null ? other$nacionalidad != null : !this$nacionalidad.equals(other$nacionalidad)) {
            return false;
        }
        String this$preferenciasViaje = this.getPreferenciasViaje();
        String other$preferenciasViaje = other.getPreferenciasViaje();
        if (this$preferenciasViaje == null ? other$preferenciasViaje != null : !this$preferenciasViaje.equals(other$preferenciasViaje)) {
            return false;
        }
        NivelMembresia this$nivelMembresia = this.getNivelMembresia();
        NivelMembresia other$nivelMembresia = other.getNivelMembresia();
        if (this$nivelMembresia == null ? other$nivelMembresia != null : !this$nivelMembresia.equals(other$nivelMembresia)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        return !(this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cliente;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idCliente = this.getIdCliente();
        result = result * 59 + ($idCliente == null ? 43 : ((Object)$idCliente).hashCode());
        Integer $puntosFidelizacion = this.getPuntosFidelizacion();
        result = result * 59 + ($puntosFidelizacion == null ? 43 : ((Object)$puntosFidelizacion).hashCode());
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        String $nombre = this.getNombre();
        result = result * 59 + ($nombre == null ? 43 : $nombre.hashCode());
        String $apellido = this.getApellido();
        result = result * 59 + ($apellido == null ? 43 : $apellido.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        result = result * 59 + Arrays.hashCode(this.getEmailEncriptado());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        result = result * 59 + Arrays.hashCode(this.getTelefonoEncriptado());
        String $dni = this.getDni();
        result = result * 59 + ($dni == null ? 43 : $dni.hashCode());
        Date $fechaNacimiento = this.getFechaNacimiento();
        result = result * 59 + ($fechaNacimiento == null ? 43 : ((Object)$fechaNacimiento).hashCode());
        String $nacionalidad = this.getNacionalidad();
        result = result * 59 + ($nacionalidad == null ? 43 : $nacionalidad.hashCode());
        String $preferenciasViaje = this.getPreferenciasViaje();
        result = result * 59 + ($preferenciasViaje == null ? 43 : $preferenciasViaje.hashCode());
        NivelMembresia $nivelMembresia = this.getNivelMembresia();
        result = result * 59 + ($nivelMembresia == null ? 43 : $nivelMembresia.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        return result;
    }

    public String toString() {
        return "Cliente(idCliente=" + this.getIdCliente() + ", empresa=" + String.valueOf(this.getEmpresa()) + ", nombre=" + this.getNombre() + ", apellido=" + this.getApellido() + ", email=" + this.getEmail() + ", emailEncriptado=" + Arrays.toString(this.getEmailEncriptado()) + ", telefono=" + this.getTelefono() + ", telefonoEncriptado=" + Arrays.toString(this.getTelefonoEncriptado()) + ", dni=" + this.getDni() + ", fechaNacimiento=" + String.valueOf(this.getFechaNacimiento()) + ", nacionalidad=" + this.getNacionalidad() + ", preferenciasViaje=" + this.getPreferenciasViaje() + ", puntosFidelizacion=" + this.getPuntosFidelizacion() + ", nivelMembresia=" + String.valueOf(this.getNivelMembresia()) + ", estado=" + this.getEstado() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ")";
    }
}

