/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="empresas")
@EntityListeners(value={AuditingEntityListener.class})
public class Empresa {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_empresa")
    private Long idEmpresa;
    @NotBlank(message="El nombre de la empresa es obligatorio")
    @Size(max=255, message="El nombre de la empresa no puede exceder 255 caracteres")
    @Column(name="nombre_empresa", nullable=false, length=255)
    private @NotBlank(message="El nombre de la empresa es obligatorio") @Size(max=255, message="El nombre de la empresa no puede exceder 255 caracteres") String nombreEmpresa;
    @NotBlank(message="El RUC es obligatorio")
    @Size(max=20, message="El RUC no puede exceder 20 caracteres")
    @Column(name="ruc", nullable=false, unique=true, length=20)
    private @NotBlank(message="El RUC es obligatorio") @Size(max=20, message="El RUC no puede exceder 20 caracteres") String ruc;
    @NotBlank(message="El email es obligatorio")
    @Size(max=255, message="El email no puede exceder 255 caracteres")
    @Column(name="email", nullable=false, unique=true, length=255)
    private @NotBlank(message="El email es obligatorio") @Size(max=255, message="El email no puede exceder 255 caracteres") String email;
    @Size(max=20, message="El tel\u00e9fono no puede exceder 20 caracteres")
    @Column(name="telefono", length=20)
    private @Size(max=20, message="El tel\u00e9fono no puede exceder 20 caracteres") String telefono;
    @Column(name="direccion", columnDefinition="TEXT")
    private String direccion;
    @Column(name="estado", nullable=false)
    private Integer estado = 1;
    @Column(name="fecha_registro", nullable=false)
    private LocalDateTime fechaRegistro;
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;

    public Long getIdEmpresa() {
        return this.idEmpresa;
    }

    public String getNombreEmpresa() {
        return this.nombreEmpresa;
    }

    public String getRuc() {
        return this.ruc;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public String getDireccion() {
        return this.direccion;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public LocalDateTime getFechaRegistro() {
        return this.fechaRegistro;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    public void setIdEmpresa(Long idEmpresa) {
        this.idEmpresa = idEmpresa;
    }

    public void setNombreEmpresa(String nombreEmpresa) {
        this.nombreEmpresa = nombreEmpresa;
    }

    public void setRuc(String ruc) {
        this.ruc = ruc;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public void setFechaRegistro(LocalDateTime fechaRegistro) {
        this.fechaRegistro = fechaRegistro;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Empresa)) {
            return false;
        }
        Empresa other = (Empresa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idEmpresa = this.getIdEmpresa();
        Long other$idEmpresa = other.getIdEmpresa();
        if (this$idEmpresa == null ? other$idEmpresa != null : !((Object)this$idEmpresa).equals(other$idEmpresa)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$nombreEmpresa = this.getNombreEmpresa();
        String other$nombreEmpresa = other.getNombreEmpresa();
        if (this$nombreEmpresa == null ? other$nombreEmpresa != null : !this$nombreEmpresa.equals(other$nombreEmpresa)) {
            return false;
        }
        String this$ruc = this.getRuc();
        String other$ruc = other.getRuc();
        if (this$ruc == null ? other$ruc != null : !this$ruc.equals(other$ruc)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        if (this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion)) {
            return false;
        }
        LocalDateTime this$fechaRegistro = this.getFechaRegistro();
        LocalDateTime other$fechaRegistro = other.getFechaRegistro();
        if (this$fechaRegistro == null ? other$fechaRegistro != null : !((Object)this$fechaRegistro).equals(other$fechaRegistro)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        return !(this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Empresa;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idEmpresa = this.getIdEmpresa();
        result = result * 59 + ($idEmpresa == null ? 43 : ((Object)$idEmpresa).hashCode());
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $nombreEmpresa = this.getNombreEmpresa();
        result = result * 59 + ($nombreEmpresa == null ? 43 : $nombreEmpresa.hashCode());
        String $ruc = this.getRuc();
        result = result * 59 + ($ruc == null ? 43 : $ruc.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        LocalDateTime $fechaRegistro = this.getFechaRegistro();
        result = result * 59 + ($fechaRegistro == null ? 43 : ((Object)$fechaRegistro).hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        return result;
    }

    public String toString() {
        return "Empresa(idEmpresa=" + this.getIdEmpresa() + ", nombreEmpresa=" + this.getNombreEmpresa() + ", ruc=" + this.getRuc() + ", email=" + this.getEmail() + ", telefono=" + this.getTelefono() + ", direccion=" + this.getDireccion() + ", estado=" + this.getEstado() + ", fechaRegistro=" + String.valueOf(this.getFechaRegistro()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ")";
    }

    public Empresa() {
    }

    public Empresa(Long idEmpresa, String nombreEmpresa, String ruc, String email, String telefono, String direccion, Integer estado, LocalDateTime fechaRegistro, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime deletedAt) {
        this.idEmpresa = idEmpresa;
        this.nombreEmpresa = nombreEmpresa;
        this.ruc = ruc;
        this.email = email;
        this.telefono = telefono;
        this.direccion = direccion;
        this.estado = estado;
        this.fechaRegistro = fechaRegistro;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
    }
}

