/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Permiso;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import java.util.Set;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="modulos")
@EntityListeners(value={AuditingEntityListener.class})
public class Modulo {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_modulo")
    private Long idModulo;
    @NotBlank(message="El nombre del m\u00f3dulo es obligatorio")
    @Size(max=100, message="El nombre del m\u00f3dulo no puede exceder 100 caracteres")
    @Column(name="nombre_modulo", nullable=false, unique=true, length=100)
    private @NotBlank(message="El nombre del m\u00f3dulo es obligatorio") @Size(max=100, message="El nombre del m\u00f3dulo no puede exceder 100 caracteres") String nombreModulo;
    @Size(max=500, message="La descripci\u00f3n no puede exceder 500 caracteres")
    @Column(name="descripcion", columnDefinition="TEXT")
    private @Size(max=500, message="La descripci\u00f3n no puede exceder 500 caracteres") String descripcion;
    @Column(name="estado", nullable=false)
    private Integer estado = 1;
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @OneToMany(mappedBy="modulo", fetch=FetchType.LAZY)
    private Set<Permiso> permisos;

    public Long getIdModulo() {
        return this.idModulo;
    }

    public String getNombreModulo() {
        return this.nombreModulo;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public Set<Permiso> getPermisos() {
        return this.permisos;
    }

    public void setIdModulo(Long idModulo) {
        this.idModulo = idModulo;
    }

    public void setNombreModulo(String nombreModulo) {
        this.nombreModulo = nombreModulo;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setPermisos(Set<Permiso> permisos) {
        this.permisos = permisos;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Modulo)) {
            return false;
        }
        Modulo other = (Modulo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idModulo = this.getIdModulo();
        Long other$idModulo = other.getIdModulo();
        if (this$idModulo == null ? other$idModulo != null : !((Object)this$idModulo).equals(other$idModulo)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$nombreModulo = this.getNombreModulo();
        String other$nombreModulo = other.getNombreModulo();
        if (this$nombreModulo == null ? other$nombreModulo != null : !this$nombreModulo.equals(other$nombreModulo)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Set this$permisos = this.getPermisos();
        Set other$permisos = other.getPermisos();
        return !(this$permisos == null ? other$permisos != null : !((Object)this$permisos).equals(other$permisos));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Modulo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idModulo = this.getIdModulo();
        result = result * 59 + ($idModulo == null ? 43 : ((Object)$idModulo).hashCode());
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $nombreModulo = this.getNombreModulo();
        result = result * 59 + ($nombreModulo == null ? 43 : $nombreModulo.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Set $permisos = this.getPermisos();
        result = result * 59 + ($permisos == null ? 43 : ((Object)$permisos).hashCode());
        return result;
    }

    public String toString() {
        return "Modulo(idModulo=" + this.getIdModulo() + ", nombreModulo=" + this.getNombreModulo() + ", descripcion=" + this.getDescripcion() + ", estado=" + this.getEstado() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", permisos=" + String.valueOf(this.getPermisos()) + ")";
    }

    public Modulo() {
    }

    public Modulo(Long idModulo, String nombreModulo, String descripcion, Integer estado, LocalDateTime createdAt, LocalDateTime updatedAt, Set<Permiso> permisos) {
        this.idModulo = idModulo;
        this.nombreModulo = nombreModulo;
        this.descripcion = descripcion;
        this.estado = estado;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.permisos = permisos;
    }
}

