/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.MovimientoCaja;
import com.sistema.turistico.entity.Venta;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="movimientos_caja")
public class MovimientoCaja {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_movimiento")
    private Long idMovimiento;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_caja", nullable=false)
    private Caja caja;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_venta")
    private Venta venta;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_movimiento", nullable=false)
    private TipoMovimiento tipoMovimiento;
    @NotNull
    @DecimalMin(value="0.01", message="El monto debe ser mayor a 0")
    @Digits(integer=10, fraction=2)
    @Column(name="monto", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.01", message="El monto debe ser mayor a 0") @Digits(integer=10, fraction=2) BigDecimal monto;
    @Column(name="descripcion", columnDefinition="TEXT")
    private String descripcion;
    @Column(name="fecha_hora", nullable=false)
    private LocalDateTime fechaHora;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;

    public Long getIdMovimiento() {
        return this.idMovimiento;
    }

    public Caja getCaja() {
        return this.caja;
    }

    public Venta getVenta() {
        return this.venta;
    }

    public TipoMovimiento getTipoMovimiento() {
        return this.tipoMovimiento;
    }

    public BigDecimal getMonto() {
        return this.monto;
    }

    public String getDescripcion() {
        return this.descripcion;
    }

    public LocalDateTime getFechaHora() {
        return this.fechaHora;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setIdMovimiento(Long idMovimiento) {
        this.idMovimiento = idMovimiento;
    }

    public void setCaja(Caja caja) {
        this.caja = caja;
    }

    public void setVenta(Venta venta) {
        this.venta = venta;
    }

    public void setTipoMovimiento(TipoMovimiento tipoMovimiento) {
        this.tipoMovimiento = tipoMovimiento;
    }

    public void setMonto(BigDecimal monto) {
        this.monto = monto;
    }

    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    public void setFechaHora(LocalDateTime fechaHora) {
        this.fechaHora = fechaHora;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public String toString() {
        return "MovimientoCaja(idMovimiento=" + this.getIdMovimiento() + ", caja=" + String.valueOf(this.getCaja()) + ", venta=" + String.valueOf(this.getVenta()) + ", tipoMovimiento=" + String.valueOf(this.getTipoMovimiento()) + ", monto=" + String.valueOf(this.getMonto()) + ", descripcion=" + this.getDescripcion() + ", fechaHora=" + String.valueOf(this.getFechaHora()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MovimientoCaja)) {
            return false;
        }
        MovimientoCaja other = (MovimientoCaja)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idMovimiento = this.getIdMovimiento();
        Long other$idMovimiento = other.getIdMovimiento();
        return !(this$idMovimiento == null ? other$idMovimiento != null : !((Object)this$idMovimiento).equals(other$idMovimiento));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MovimientoCaja;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idMovimiento = this.getIdMovimiento();
        result = result * 59 + ($idMovimiento == null ? 43 : ((Object)$idMovimiento).hashCode());
        return result;
    }
}

