/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.ServicioTuristico;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(name="paquetes_servicios", uniqueConstraints={@UniqueConstraint(columnNames={"id_paquete", "id_servicio"})})
public class PaqueteServicio {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_paquete_servicio")
    private Long idPaqueteServicio;
    @NotNull(message="El paquete es obligatorio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_paquete", nullable=false)
    private @NotNull(message="El paquete es obligatorio") PaqueteTuristico paquete;
    @NotNull(message="El servicio es obligatorio")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_servicio", nullable=false)
    private @NotNull(message="El servicio es obligatorio") ServicioTuristico servicio;
    @NotNull(message="El orden es obligatorio")
    @Min(value=1L, message="El orden debe ser mayor a 0")
    @Column(nullable=false, columnDefinition="INT DEFAULT 1")
    private @NotNull(message="El orden es obligatorio") @Min(value=1L, message="El orden debe ser mayor a 0") Integer orden = 1;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;

    public PaqueteServicio(PaqueteTuristico paquete, ServicioTuristico servicio, Integer orden) {
        this.paquete = paquete;
        this.servicio = servicio;
        this.orden = orden != null ? orden : 1;
    }

    public boolean isServicioActivo() {
        return this.servicio != null && this.servicio.isActivo();
    }

    public BigDecimal getPrecioServicio() {
        return this.servicio != null ? this.servicio.getPrecioBase() : BigDecimal.ZERO;
    }

    @PrePersist
    protected void onCreate() {
        if (this.createdAt == null) {
            this.createdAt = LocalDateTime.now();
        }
        if (this.orden == null) {
            this.orden = 1;
        }
    }

    public Long getIdPaqueteServicio() {
        return this.idPaqueteServicio;
    }

    public PaqueteTuristico getPaquete() {
        return this.paquete;
    }

    public ServicioTuristico getServicio() {
        return this.servicio;
    }

    public Integer getOrden() {
        return this.orden;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setIdPaqueteServicio(Long idPaqueteServicio) {
        this.idPaqueteServicio = idPaqueteServicio;
    }

    public void setPaquete(PaqueteTuristico paquete) {
        this.paquete = paquete;
    }

    public void setServicio(ServicioTuristico servicio) {
        this.servicio = servicio;
    }

    public void setOrden(Integer orden) {
        this.orden = orden;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaqueteServicio)) {
            return false;
        }
        PaqueteServicio other = (PaqueteServicio)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPaqueteServicio = this.getIdPaqueteServicio();
        Long other$idPaqueteServicio = other.getIdPaqueteServicio();
        if (this$idPaqueteServicio == null ? other$idPaqueteServicio != null : !((Object)this$idPaqueteServicio).equals(other$idPaqueteServicio)) {
            return false;
        }
        Integer this$orden = this.getOrden();
        Integer other$orden = other.getOrden();
        if (this$orden == null ? other$orden != null : !((Object)this$orden).equals(other$orden)) {
            return false;
        }
        PaqueteTuristico this$paquete = this.getPaquete();
        PaqueteTuristico other$paquete = other.getPaquete();
        if (this$paquete == null ? other$paquete != null : !this$paquete.equals(other$paquete)) {
            return false;
        }
        ServicioTuristico this$servicio = this.getServicio();
        ServicioTuristico other$servicio = other.getServicio();
        if (this$servicio == null ? other$servicio != null : !this$servicio.equals(other$servicio)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PaqueteServicio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPaqueteServicio = this.getIdPaqueteServicio();
        result = result * 59 + ($idPaqueteServicio == null ? 43 : ((Object)$idPaqueteServicio).hashCode());
        Integer $orden = this.getOrden();
        result = result * 59 + ($orden == null ? 43 : ((Object)$orden).hashCode());
        PaqueteTuristico $paquete = this.getPaquete();
        result = result * 59 + ($paquete == null ? 43 : $paquete.hashCode());
        ServicioTuristico $servicio = this.getServicio();
        result = result * 59 + ($servicio == null ? 43 : $servicio.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "PaqueteServicio(idPaqueteServicio=" + this.getIdPaqueteServicio() + ", paquete=" + String.valueOf(this.getPaquete()) + ", servicio=" + String.valueOf(this.getServicio()) + ", orden=" + this.getOrden() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    public PaqueteServicio() {
    }

    public PaqueteServicio(Long idPaqueteServicio, PaqueteTuristico paquete, ServicioTuristico servicio, Integer orden, LocalDateTime createdAt) {
        this.idPaqueteServicio = idPaqueteServicio;
        this.paquete = paquete;
        this.servicio = servicio;
        this.orden = orden;
        this.createdAt = createdAt;
    }
}

