/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ReservaItem;
import com.sistema.turistico.entity.ServicioTuristico;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="reserva_items", indexes={@Index(name="idx_reserva_items_reserva", columnList="id_reserva"), @Index(name="idx_reserva_items_servicio", columnList="id_servicio"), @Index(name="idx_reserva_items_paquete", columnList="id_paquete")})
public class ReservaItem {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_reserva_item")
    private Long idReservaItem;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva", nullable=false)
    private Reserva reserva;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_item", nullable=false, length=20)
    private TipoItem tipoItem;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_servicio")
    private ServicioTuristico servicio;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_paquete")
    private PaqueteTuristico paquete;
    @NotNull
    @Min(value=1L, message="La cantidad debe ser al menos 1")
    @Column(name="cantidad", nullable=false)
    private @NotNull @Min(value=1L, message="La cantidad debe ser al menos 1") Integer cantidad = 1;
    @NotNull
    @DecimalMin(value="0.00", message="El precio unitario no puede ser negativo")
    @Digits(integer=10, fraction=2, message="El precio unitario debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    @Column(name="precio_unitario", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.00", message="El precio unitario no puede ser negativo") @Digits(integer=10, fraction=2, message="El precio unitario debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal precioUnitario;
    @NotNull
    @DecimalMin(value="0.00", message="El precio total no puede ser negativo")
    @Digits(integer=10, fraction=2, message="El precio total debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    @Column(name="precio_total", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.00", message="El precio total no puede ser negativo") @Digits(integer=10, fraction=2, message="El precio total debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal precioTotal;
    @Column(name="descripcion_extra", length=500)
    private String descripcionExtra;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;

    public boolean esServicio() {
        return TipoItem.SERVICIO.equals((Object)this.tipoItem);
    }

    public boolean esPaquete() {
        return TipoItem.PAQUETE.equals((Object)this.tipoItem);
    }

    @PrePersist
    @PreUpdate
    private void sincronizarImportes() {
        if (this.precioUnitario != null && this.cantidad != null) {
            BigDecimal calculado = this.precioUnitario.multiply(BigDecimal.valueOf(this.cantidad.intValue()));
            if (this.precioTotal == null || this.precioTotal.compareTo(calculado) != 0) {
                this.precioTotal = calculado;
            }
        }
    }

    public Long getIdReservaItem() {
        return this.idReservaItem;
    }

    public Reserva getReserva() {
        return this.reserva;
    }

    public TipoItem getTipoItem() {
        return this.tipoItem;
    }

    public ServicioTuristico getServicio() {
        return this.servicio;
    }

    public PaqueteTuristico getPaquete() {
        return this.paquete;
    }

    public Integer getCantidad() {
        return this.cantidad;
    }

    public BigDecimal getPrecioUnitario() {
        return this.precioUnitario;
    }

    public BigDecimal getPrecioTotal() {
        return this.precioTotal;
    }

    public String getDescripcionExtra() {
        return this.descripcionExtra;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setIdReservaItem(Long idReservaItem) {
        this.idReservaItem = idReservaItem;
    }

    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    public void setTipoItem(TipoItem tipoItem) {
        this.tipoItem = tipoItem;
    }

    public void setServicio(ServicioTuristico servicio) {
        this.servicio = servicio;
    }

    public void setPaquete(PaqueteTuristico paquete) {
        this.paquete = paquete;
    }

    public void setCantidad(Integer cantidad) {
        this.cantidad = cantidad;
    }

    public void setPrecioUnitario(BigDecimal precioUnitario) {
        this.precioUnitario = precioUnitario;
    }

    public void setPrecioTotal(BigDecimal precioTotal) {
        this.precioTotal = precioTotal;
    }

    public void setDescripcionExtra(String descripcionExtra) {
        this.descripcionExtra = descripcionExtra;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReservaItem)) {
            return false;
        }
        ReservaItem other = (ReservaItem)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idReservaItem = this.getIdReservaItem();
        Long other$idReservaItem = other.getIdReservaItem();
        if (this$idReservaItem == null ? other$idReservaItem != null : !((Object)this$idReservaItem).equals(other$idReservaItem)) {
            return false;
        }
        Integer this$cantidad = this.getCantidad();
        Integer other$cantidad = other.getCantidad();
        if (this$cantidad == null ? other$cantidad != null : !((Object)this$cantidad).equals(other$cantidad)) {
            return false;
        }
        Reserva this$reserva = this.getReserva();
        Reserva other$reserva = other.getReserva();
        if (this$reserva == null ? other$reserva != null : !this$reserva.equals(other$reserva)) {
            return false;
        }
        TipoItem this$tipoItem = this.getTipoItem();
        TipoItem other$tipoItem = other.getTipoItem();
        if (this$tipoItem == null ? other$tipoItem != null : !this$tipoItem.equals(other$tipoItem)) {
            return false;
        }
        ServicioTuristico this$servicio = this.getServicio();
        ServicioTuristico other$servicio = other.getServicio();
        if (this$servicio == null ? other$servicio != null : !this$servicio.equals(other$servicio)) {
            return false;
        }
        PaqueteTuristico this$paquete = this.getPaquete();
        PaqueteTuristico other$paquete = other.getPaquete();
        if (this$paquete == null ? other$paquete != null : !this$paquete.equals(other$paquete)) {
            return false;
        }
        BigDecimal this$precioUnitario = this.getPrecioUnitario();
        BigDecimal other$precioUnitario = other.getPrecioUnitario();
        if (this$precioUnitario == null ? other$precioUnitario != null : !((Object)this$precioUnitario).equals(other$precioUnitario)) {
            return false;
        }
        BigDecimal this$precioTotal = this.getPrecioTotal();
        BigDecimal other$precioTotal = other.getPrecioTotal();
        if (this$precioTotal == null ? other$precioTotal != null : !((Object)this$precioTotal).equals(other$precioTotal)) {
            return false;
        }
        String this$descripcionExtra = this.getDescripcionExtra();
        String other$descripcionExtra = other.getDescripcionExtra();
        if (this$descripcionExtra == null ? other$descripcionExtra != null : !this$descripcionExtra.equals(other$descripcionExtra)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReservaItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idReservaItem = this.getIdReservaItem();
        result = result * 59 + ($idReservaItem == null ? 43 : ((Object)$idReservaItem).hashCode());
        Integer $cantidad = this.getCantidad();
        result = result * 59 + ($cantidad == null ? 43 : ((Object)$cantidad).hashCode());
        Reserva $reserva = this.getReserva();
        result = result * 59 + ($reserva == null ? 43 : $reserva.hashCode());
        TipoItem $tipoItem = this.getTipoItem();
        result = result * 59 + ($tipoItem == null ? 43 : $tipoItem.hashCode());
        ServicioTuristico $servicio = this.getServicio();
        result = result * 59 + ($servicio == null ? 43 : $servicio.hashCode());
        PaqueteTuristico $paquete = this.getPaquete();
        result = result * 59 + ($paquete == null ? 43 : $paquete.hashCode());
        BigDecimal $precioUnitario = this.getPrecioUnitario();
        result = result * 59 + ($precioUnitario == null ? 43 : ((Object)$precioUnitario).hashCode());
        BigDecimal $precioTotal = this.getPrecioTotal();
        result = result * 59 + ($precioTotal == null ? 43 : ((Object)$precioTotal).hashCode());
        String $descripcionExtra = this.getDescripcionExtra();
        result = result * 59 + ($descripcionExtra == null ? 43 : $descripcionExtra.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    public String toString() {
        return "ReservaItem(idReservaItem=" + this.getIdReservaItem() + ", tipoItem=" + String.valueOf(this.getTipoItem()) + ", servicio=" + String.valueOf(this.getServicio()) + ", paquete=" + String.valueOf(this.getPaquete()) + ", cantidad=" + this.getCantidad() + ", precioUnitario=" + String.valueOf(this.getPrecioUnitario()) + ", precioTotal=" + String.valueOf(this.getPrecioTotal()) + ", descripcionExtra=" + this.getDescripcionExtra() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }
}

