/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Empresa;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="sucursales")
@EntityListeners(value={AuditingEntityListener.class})
public class Sucursal {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_sucursal")
    private Long idSucursal;
    @NotBlank(message="El nombre de la sucursal es obligatorio")
    @Size(max=255, message="El nombre de la sucursal no puede exceder 255 caracteres")
    @Column(name="nombre_sucursal", nullable=false, length=255)
    private @NotBlank(message="El nombre de la sucursal es obligatorio") @Size(max=255, message="El nombre de la sucursal no puede exceder 255 caracteres") String nombreSucursal;
    @NotBlank(message="La ubicaci\u00f3n es obligatoria")
    @Size(max=255, message="La ubicaci\u00f3n no puede exceder 255 caracteres")
    @Column(name="ubicacion", nullable=false, length=255)
    private @NotBlank(message="La ubicaci\u00f3n es obligatoria") @Size(max=255, message="La ubicaci\u00f3n no puede exceder 255 caracteres") String ubicacion;
    @Column(name="direccion", columnDefinition="TEXT")
    private String direccion;
    @Size(max=20, message="El tel\u00e9fono no puede exceder 20 caracteres")
    @Column(name="telefono", length=20)
    private @Size(max=20, message="El tel\u00e9fono no puede exceder 20 caracteres") String telefono;
    @Size(max=255, message="El email no puede exceder 255 caracteres")
    @Column(name="email", length=255)
    private @Size(max=255, message="El email no puede exceder 255 caracteres") String email;
    @Size(max=255, message="El gerente no puede exceder 255 caracteres")
    @Column(name="gerente", length=255)
    private @Size(max=255, message="El gerente no puede exceder 255 caracteres") String gerente;
    @Column(name="estado", nullable=false)
    private Integer estado = 1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private Empresa empresa;
    @CreatedDate
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @LastModifiedDate
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;

    public Long getIdSucursal() {
        return this.idSucursal;
    }

    public String getNombreSucursal() {
        return this.nombreSucursal;
    }

    public String getUbicacion() {
        return this.ubicacion;
    }

    public String getDireccion() {
        return this.direccion;
    }

    public String getTelefono() {
        return this.telefono;
    }

    public String getEmail() {
        return this.email;
    }

    public String getGerente() {
        return this.gerente;
    }

    public Integer getEstado() {
        return this.estado;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    public void setIdSucursal(Long idSucursal) {
        this.idSucursal = idSucursal;
    }

    public void setNombreSucursal(String nombreSucursal) {
        this.nombreSucursal = nombreSucursal;
    }

    public void setUbicacion(String ubicacion) {
        this.ubicacion = ubicacion;
    }

    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setGerente(String gerente) {
        this.gerente = gerente;
    }

    public void setEstado(Integer estado) {
        this.estado = estado;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sucursal)) {
            return false;
        }
        Sucursal other = (Sucursal)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idSucursal = this.getIdSucursal();
        Long other$idSucursal = other.getIdSucursal();
        if (this$idSucursal == null ? other$idSucursal != null : !((Object)this$idSucursal).equals(other$idSucursal)) {
            return false;
        }
        Integer this$estado = this.getEstado();
        Integer other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        String this$nombreSucursal = this.getNombreSucursal();
        String other$nombreSucursal = other.getNombreSucursal();
        if (this$nombreSucursal == null ? other$nombreSucursal != null : !this$nombreSucursal.equals(other$nombreSucursal)) {
            return false;
        }
        String this$ubicacion = this.getUbicacion();
        String other$ubicacion = other.getUbicacion();
        if (this$ubicacion == null ? other$ubicacion != null : !this$ubicacion.equals(other$ubicacion)) {
            return false;
        }
        String this$direccion = this.getDireccion();
        String other$direccion = other.getDireccion();
        if (this$direccion == null ? other$direccion != null : !this$direccion.equals(other$direccion)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$gerente = this.getGerente();
        String other$gerente = other.getGerente();
        if (this$gerente == null ? other$gerente != null : !this$gerente.equals(other$gerente)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        return !(this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Sucursal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idSucursal = this.getIdSucursal();
        result = result * 59 + ($idSucursal == null ? 43 : ((Object)$idSucursal).hashCode());
        Integer $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        String $nombreSucursal = this.getNombreSucursal();
        result = result * 59 + ($nombreSucursal == null ? 43 : $nombreSucursal.hashCode());
        String $ubicacion = this.getUbicacion();
        result = result * 59 + ($ubicacion == null ? 43 : $ubicacion.hashCode());
        String $direccion = this.getDireccion();
        result = result * 59 + ($direccion == null ? 43 : $direccion.hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $gerente = this.getGerente();
        result = result * 59 + ($gerente == null ? 43 : $gerente.hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        return result;
    }

    public String toString() {
        return "Sucursal(idSucursal=" + this.getIdSucursal() + ", nombreSucursal=" + this.getNombreSucursal() + ", ubicacion=" + this.getUbicacion() + ", direccion=" + this.getDireccion() + ", telefono=" + this.getTelefono() + ", email=" + this.getEmail() + ", gerente=" + this.getGerente() + ", estado=" + this.getEstado() + ", empresa=" + String.valueOf(this.getEmpresa()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ")";
    }

    public Sucursal() {
    }

    public Sucursal(Long idSucursal, String nombreSucursal, String ubicacion, String direccion, String telefono, String email, String gerente, Integer estado, Empresa empresa, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime deletedAt) {
        this.idSucursal = idSucursal;
        this.nombreSucursal = nombreSucursal;
        this.ubicacion = ubicacion;
        this.direccion = direccion;
        this.telefono = telefono;
        this.email = email;
        this.gerente = gerente;
        this.estado = estado;
        this.empresa = empresa;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.deletedAt = deletedAt;
    }
}

