/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.Reserva;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ReservaRepository
extends JpaRepository<Reserva, Long> {
    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.deletedAt IS NULL ORDER BY r.createdAt DESC")
    public List<Reserva> findByEmpresaIdOrderByCreatedAtDesc(@Param(value="empresaId") Long var1);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.cliente.idCliente = :clienteId AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaIdAndClienteId(@Param(value="empresaId") Long var1, @Param(value="clienteId") Long var2);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.estado = :estado AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaIdAndEstado(@Param(value="empresaId") Long var1, @Param(value="estado") Reserva.EstadoReserva var2);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.fechaServicio = :fechaServicio AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaIdAndFechaServicio(@Param(value="empresaId") Long var1, @Param(value="fechaServicio") Date var2);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.fechaServicio BETWEEN :fechaInicio AND :fechaFin AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaIdAndFechaServicioBetween(@Param(value="empresaId") Long var1, @Param(value="fechaInicio") Date var2, @Param(value="fechaFin") Date var3);

    @Query(value="SELECT DISTINCT r FROM Reserva r JOIN r.items i WHERE r.empresa.idEmpresa = :empresaId AND i.tipoItem = com.sistema.turistico.entity.ReservaItem$TipoItem.SERVICIO AND i.servicio.idServicio = :servicioId AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaIdAndServicioId(@Param(value="empresaId") Long var1, @Param(value="servicioId") Long var2);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.deletedAt IS NULL AND (LOWER(r.codigoReserva) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(r.cliente.nombre) LIKE LOWER(CONCAT('%', :busqueda, '%')) OR LOWER(r.cliente.apellido) LIKE LOWER(CONCAT('%', :busqueda, '%')))")
    public List<Reserva> findByEmpresaIdAndBusqueda(@Param(value="empresaId") Long var1, @Param(value="busqueda") String var2);

    @Query(value="SELECT COUNT(r) > 0 FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.codigoReserva = :codigoReserva AND r.idReserva != :excludeId")
    public boolean existsByEmpresaIdAndCodigoReservaAndIdNot(@Param(value="empresaId") Long var1, @Param(value="codigoReserva") String var2, @Param(value="excludeId") Long var3);

    @Query(value="SELECT COUNT(r) FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.deletedAt IS NULL")
    public Long countByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT r.estado, COUNT(r) FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.deletedAt IS NULL GROUP BY r.estado")
    public List<Object[]> countReservasByEstado(@Param(value="empresaId") Long var1);

    @Query(value="SELECT SUM(r.precioTotal) FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.estado IN ('Pagada', 'Completada') AND r.deletedAt IS NULL")
    public BigDecimal sumIngresosByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.estado = 'Completada' AND r.evaluada = false AND r.deletedAt IS NULL")
    public List<Reserva> findReservasPendientesEvaluacion(@Param(value="empresaId") Long var1);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND r.fechaServicio BETWEEN :hoy AND :enUnaSemana AND r.estado IN ('Confirmada', 'Pagada') AND r.deletedAt IS NULL ORDER BY r.fechaServicio")
    public List<Reserva> findReservasProximas(@Param(value="empresaId") Long var1, @Param(value="hoy") Date var2, @Param(value="enUnaSemana") Date var3);

    @Query(value="SELECT r FROM Reserva r WHERE r.empresa.idEmpresa = :empresaId AND DATE(r.createdAt) BETWEEN :fechaInicio AND :fechaFin AND r.deletedAt IS NULL")
    public List<Reserva> findByEmpresaAndFechaRango(@Param(value="empresaId") Long var1, @Param(value="fechaInicio") LocalDate var2, @Param(value="fechaFin") LocalDate var3);
}

