/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.security;

import java.util.Collection;
import java.util.Objects;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class AuthenticatedUser
implements UserDetails {
    private final Long userId;
    private final Long empresaId;
    private final UserDetails delegate;

    private AuthenticatedUser(Long userId, Long empresaId, UserDetails delegate) {
        this.userId = userId;
        this.empresaId = empresaId;
        this.delegate = delegate;
    }

    public static AuthenticatedUser of(Long userId, Long empresaId, UserDetails delegate) {
        Objects.requireNonNull(delegate, "delegate must not be null");
        return new AuthenticatedUser(userId, empresaId, delegate);
    }

    public Long getUserId() {
        return this.userId;
    }

    public Long getEmpresaId() {
        return this.empresaId;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.delegate.getAuthorities();
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this.delegate.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.delegate.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this.delegate.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.delegate.isEnabled();
    }
}

