/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.ServicioResponse;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.ServicioTuristicoRepository;
import com.sistema.turistico.security.TenantContext;
import com.sistema.turistico.service.ServicioTuristicoService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ServicioTuristicoService {
    private static final Logger log = LoggerFactory.getLogger(ServicioTuristicoService.class);
    private final ServicioTuristicoRepository servicioRepository;
    private final EmpresaRepository empresaRepository;

    public ServicioTuristico create(ServicioTuristico servicio) {
        log.info("Creando nuevo servicio tur\u00edstico: {}", (Object)(servicio != null ? servicio.getNombreServicio() : null));
        if (servicio == null) {
            throw new IllegalArgumentException("El servicio es obligatorio");
        }
        Long empresaSolicitada = servicio.getEmpresa() != null ? servicio.getEmpresa().getIdEmpresa() : null;
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)empresaSolicitada);
        Empresa empresa = this.obtenerEmpresaActiva(empresaId);
        this.normalizarServicio(servicio);
        this.validarServicio(servicio);
        if (this.servicioRepository.existsByEmpresaIdAndNombreServicioAndIdNot(empresaId, servicio.getNombreServicio(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe un servicio con este nombre en la empresa");
        }
        servicio.setEmpresa(empresa);
        servicio.setEstado(Boolean.TRUE);
        servicio.setDeletedAt(null);
        ServicioTuristico savedServicio = (ServicioTuristico)this.servicioRepository.save((Object)servicio);
        log.info("Servicio tur\u00edstico creado exitosamente con ID: {}", (Object)savedServicio.getIdServicio());
        return savedServicio;
    }

    @Transactional(readOnly=true)
    public Optional<ServicioTuristico> findById(Long id) {
        log.debug("Buscando servicio tur\u00edstico con ID: {}", (Object)id);
        return this.servicioRepository.findById((Object)id).filter(servicio -> servicio.getDeletedAt() == null).map(servicio -> {
            this.validarPertenencia(servicio);
            return servicio;
        });
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Listando servicios tur\u00edsticos de empresa ID: {}", (Object)empresaFiltrada);
        return this.servicioRepository.findByEmpresaId(empresaFiltrada);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaIdAndTipoServicio(Long empresaId, ServicioTuristico.TipoServicio tipoServicio) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Listando servicios de empresa {} y tipo {}", (Object)empresaFiltrada, (Object)tipoServicio);
        return this.servicioRepository.findByEmpresaIdAndTipoServicio(empresaFiltrada, tipoServicio);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findDisponiblesByEmpresaIdAndPersonas(Long empresaId, Integer personasRequeridas) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando servicios disponibles para {} personas en empresa {}", (Object)personasRequeridas, (Object)empresaFiltrada);
        return this.servicioRepository.findDisponiblesByEmpresaIdAndPersonas(empresaFiltrada, personasRequeridas);
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando servicios en empresa {} con t\u00e9rmino: {}", (Object)empresaFiltrada, (Object)busqueda);
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.servicioRepository.findByEmpresaIdOrderByCreatedAtDesc(empresaFiltrada);
        }
        return this.servicioRepository.findByEmpresaIdAndBusqueda(empresaFiltrada, busqueda.trim());
    }

    @Transactional(readOnly=true)
    public List<ServicioTuristico> findByEmpresaIdAndPrecioBetween(Long empresaId, BigDecimal precioMin, BigDecimal precioMax) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando servicios en empresa {} entre precios {} - {}", new Object[]{empresaFiltrada, precioMin, precioMax});
        return this.servicioRepository.findByEmpresaIdAndPrecioBetween(empresaFiltrada, precioMin, precioMax);
    }

    public ServicioTuristico update(Long id, ServicioTuristico servicioActualizado) {
        log.info("Actualizando servicio tur\u00edstico ID: {}", (Object)id);
        if (servicioActualizado == null) {
            throw new IllegalArgumentException("El servicio es obligatorio");
        }
        ServicioTuristico servicioExistente = this.obtenerServicioAutorizado(id);
        this.normalizarServicio(servicioActualizado);
        this.validarServicio(servicioActualizado);
        if (this.servicioRepository.existsByEmpresaIdAndNombreServicioAndIdNot(servicioExistente.getEmpresa().getIdEmpresa(), servicioActualizado.getNombreServicio(), id)) {
            throw new IllegalArgumentException("Ya existe un servicio con este nombre en la empresa");
        }
        servicioExistente.setNombreServicio(servicioActualizado.getNombreServicio());
        servicioExistente.setTipoServicio(servicioActualizado.getTipoServicio());
        servicioExistente.setDescripcion(servicioActualizado.getDescripcion());
        servicioExistente.setUbicacionDestino(servicioActualizado.getUbicacionDestino());
        servicioExistente.setDuracion(servicioActualizado.getDuracion());
        servicioExistente.setCapacidadMaxima(servicioActualizado.getCapacidadMaxima());
        servicioExistente.setPrecioBase(servicioActualizado.getPrecioBase());
        servicioExistente.setIncluye(servicioActualizado.getIncluye());
        servicioExistente.setNoIncluye(servicioActualizado.getNoIncluye());
        servicioExistente.setRequisitos(servicioActualizado.getRequisitos());
        servicioExistente.setPoliticasEspeciales(servicioActualizado.getPoliticasEspeciales());
        servicioExistente.setImagenes(servicioActualizado.getImagenes());
        servicioExistente.setItinerario(servicioActualizado.getItinerario());
        servicioExistente.setIdCategoria(servicioActualizado.getIdCategoria());
        servicioExistente.setIdProveedor(servicioActualizado.getIdProveedor());
        if (servicioActualizado.getEstado() != null) {
            servicioExistente.setEstado(servicioActualizado.getEstado());
        }
        ServicioTuristico updatedServicio = (ServicioTuristico)this.servicioRepository.save((Object)servicioExistente);
        log.info("Servicio tur\u00edstico actualizado exitosamente: {}", (Object)updatedServicio.getIdServicio());
        return updatedServicio;
    }

    public void delete(Long id) {
        log.info("Eliminando servicio tur\u00edstico ID: {} (soft delete)", (Object)id);
        ServicioTuristico servicio = this.obtenerServicioAutorizado(id);
        if (servicio.getDeletedAt() != null) {
            throw new IllegalArgumentException("El servicio ya fue eliminado");
        }
        servicio.setEstado(Boolean.valueOf(false));
        servicio.setDeletedAt(LocalDateTime.now());
        this.servicioRepository.save((Object)servicio);
        log.info("Servicio tur\u00edstico eliminado exitosamente: {}", (Object)id);
    }

    @Transactional(readOnly=true)
    public boolean verificarDisponibilidad(Long servicioId, Integer personasRequeridas) {
        return this.findById(servicioId).map(servicio -> servicio.isActivo() && servicio.tieneDisponibilidad(personasRequeridas)).orElse(false);
    }

    @Transactional(readOnly=true)
    public BigDecimal calcularPrecioTotal(Long servicioId, Integer personas) {
        ServicioTuristico servicio = this.obtenerServicioAutorizado(servicioId);
        if (!servicio.isActivo()) {
            throw new IllegalArgumentException("El servicio no est\u00e1 disponible");
        }
        return servicio.calcularPrecioTotal(personas);
    }

    private void validarServicio(ServicioTuristico servicio) {
        if (servicio.getCapacidadMaxima() <= 0) {
            throw new IllegalArgumentException("La capacidad m\u00e1xima debe ser mayor a 0");
        }
        if (servicio.getPrecioBase().compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("El precio base debe ser mayor a 0");
        }
        switch (1.$SwitchMap$com$sistema$turistico$entity$ServicioTuristico$TipoServicio[servicio.getTipoServicio().ordinal()]) {
            case 1: {
                if (servicio.getDuracion() != null && !servicio.getDuracion().trim().isEmpty()) break;
                throw new IllegalArgumentException("Los tours requieren especificar la duraci\u00f3n");
            }
            case 2: {
                if (servicio.getUbicacionDestino() != null && !servicio.getUbicacionDestino().trim().isEmpty()) break;
                throw new IllegalArgumentException("Los hoteles requieren especificar la ubicaci\u00f3n");
            }
            case 3: {
                break;
            }
        }
    }

    @Transactional(readOnly=true)
    public Long countByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        return this.servicioRepository.countByEmpresaId(empresaFiltrada);
    }

    public ServicioResponse toResponse(ServicioTuristico servicio) {
        return new ServicioResponse(servicio.getIdServicio(), servicio.getTipoServicio().toString(), servicio.getNombreServicio(), servicio.getDescripcion(), servicio.getUbicacionDestino(), servicio.getDuracion(), servicio.getCapacidadMaxima(), servicio.getPrecioBase(), servicio.getIncluye(), servicio.getNoIncluye(), servicio.getRequisitos(), servicio.getPoliticasEspeciales(), servicio.getEstado().booleanValue(), servicio.getCreatedAt() != null ? servicio.getCreatedAt().toString() : null, servicio.getUpdatedAt() != null ? servicio.getUpdatedAt().toString() : null);
    }

    private void normalizarServicio(ServicioTuristico servicio) {
        if (servicio.getNombreServicio() != null) {
            servicio.setNombreServicio(servicio.getNombreServicio().trim());
        }
        if (servicio.getDescripcion() != null) {
            servicio.setDescripcion(servicio.getDescripcion().trim());
        }
        if (servicio.getUbicacionDestino() != null) {
            servicio.setUbicacionDestino(servicio.getUbicacionDestino().trim());
        }
        if (servicio.getDuracion() != null) {
            servicio.setDuracion(servicio.getDuracion().trim());
        }
        if (servicio.getIncluye() != null) {
            servicio.setIncluye(servicio.getIncluye().trim());
        }
        if (servicio.getNoIncluye() != null) {
            servicio.setNoIncluye(servicio.getNoIncluye().trim());
        }
        if (servicio.getRequisitos() != null) {
            servicio.setRequisitos(servicio.getRequisitos().trim());
        }
        if (servicio.getPoliticasEspeciales() != null) {
            servicio.setPoliticasEspeciales(servicio.getPoliticasEspeciales().trim());
        }
        if (servicio.getItinerario() != null) {
            servicio.setItinerario(servicio.getItinerario().trim());
        }
    }

    private ServicioTuristico obtenerServicioAutorizado(Long id) {
        ServicioTuristico servicio = (ServicioTuristico)this.servicioRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        if (servicio.getDeletedAt() != null) {
            throw new IllegalArgumentException("Servicio tur\u00edstico no encontrado");
        }
        this.validarPertenencia(servicio);
        return servicio;
    }

    private boolean esSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    private Empresa obtenerEmpresaActiva(Long empresaId) {
        return (Empresa)this.empresaRepository.findActivaById(empresaId).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
    }

    private void validarPertenencia(ServicioTuristico servicio) {
        if (!this.esSuperAdmin()) {
            Long empresaServicio;
            Long empresaActual = TenantContext.requireEmpresaId();
            Long l = empresaServicio = servicio.getEmpresa() != null ? servicio.getEmpresa().getIdEmpresa() : null;
            if (!empresaActual.equals(empresaServicio)) {
                throw new IllegalArgumentException("El servicio no pertenece a la empresa actual");
            }
        }
    }

    public ServicioTuristicoService(ServicioTuristicoRepository servicioRepository, EmpresaRepository empresaRepository) {
        this.servicioRepository = servicioRepository;
        this.empresaRepository = empresaRepository;
    }
}

