/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.AsignacionPersonalRequest;
import com.sistema.turistico.dto.AsignacionPersonalUpdateRequest;
import com.sistema.turistico.dto.ReservaAsignacionPayload;
import com.sistema.turistico.dto.ReservaAsignacionResponse;
import com.sistema.turistico.dto.ReservaAsignacionSyncRequest;
import com.sistema.turistico.dto.ReservaEditRequest;
import com.sistema.turistico.dto.ReservaItemRequest;
import com.sistema.turistico.dto.ReservaItemResponse;
import com.sistema.turistico.dto.ReservaRequest;
import com.sistema.turistico.dto.ReservaResponse;
import com.sistema.turistico.dto.ReservaUpdateRequest;
import com.sistema.turistico.dto.VoucherResponse;
import com.sistema.turistico.entity.AsignacionPersonal;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.PaqueteServicio;
import com.sistema.turistico.entity.PaqueteTuristico;
import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.ReservaItem;
import com.sistema.turistico.entity.ServicioTuristico;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.repository.AsignacionPersonalRepository;
import com.sistema.turistico.repository.EmpresaRepository;
import com.sistema.turistico.repository.ReservaRepository;
import com.sistema.turistico.repository.UsuarioRepository;
import com.sistema.turistico.security.TenantContext;
import com.sistema.turistico.service.AsignacionPersonalService;
import com.sistema.turistico.service.ClienteService;
import com.sistema.turistico.service.PaqueteTuristicoService;
import com.sistema.turistico.service.ServicioTuristicoService;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ReservaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReservaService.class);
    private final ReservaRepository reservaRepository;
    private final ClienteService clienteService;
    private final ServicioTuristicoService servicioService;
    private final PaqueteTuristicoService paqueteService;
    private final EmpresaRepository empresaRepository;
    private final UsuarioRepository usuarioRepository;
    private final AsignacionPersonalService asignacionPersonalService;
    private final AsignacionPersonalRepository asignacionPersonalRepository;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$ReservaItem$TipoItem;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva;

    public Reserva create(ReservaRequest request) {
        String codigoReserva;
        if (request == null) {
            throw new IllegalArgumentException("La reserva es obligatoria");
        }
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)request.getEmpresaId());
        Empresa empresa = this.obtenerEmpresaActiva(empresaId);
        log.info("Creando nueva reserva para cliente ID: {} en empresa {}", (Object)request.getClienteId(), (Object)empresaId);
        Cliente cliente = (Cliente)this.clienteService.findById(request.getClienteId()).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
        this.validarMismaEmpresa(empresaId, cliente.getEmpresa() != null ? cliente.getEmpresa().getIdEmpresa() : null, "cliente");
        if (!cliente.isActivo()) {
            throw new IllegalArgumentException("El cliente no est\u00e1 activo");
        }
        List itemRequests = request.getItems();
        if (itemRequests == null || itemRequests.isEmpty()) {
            throw new IllegalArgumentException("Debe especificar al menos un item para la reserva");
        }
        Reserva reserva = new Reserva();
        reserva.setEmpresa(empresa);
        reserva.setCliente(cliente);
        reserva.setUsuario(this.obtenerUsuarioActual(empresa));
        reserva.setEstado(Reserva.EstadoReserva.Pendiente);
        reserva.setEvaluada(Boolean.valueOf(false));
        reserva.setObservaciones(request.getObservaciones());
        reserva.setIdPromocion(request.getPromocionId());
        reserva.setDescuentoAplicado(request.getDescuentoAplicado() != null ? request.getDescuentoAplicado() : BigDecimal.ZERO);
        Date fechaReserva = request.getFechaReserva() != null && !request.getFechaReserva().isBlank() ? this.parseSqlDate(request.getFechaReserva(), "fecha de reserva") : Date.valueOf(LocalDate.now());
        Date fechaServicio = this.parseSqlDate(request.getFechaServicio(), "fecha de servicio");
        reserva.setFechaReserva(fechaReserva);
        reserva.setFechaServicio(fechaServicio);
        this.validarFechas(reserva);
        ArrayList<ReservaItem> items = new ArrayList<ReservaItem>();
        int totalPersonas = 0;
        BigDecimal totalReserva = BigDecimal.ZERO;
        for (ReservaItemRequest itemRequest : itemRequests) {
            ReservaItem item = this.construirItem(itemRequest, empresaId);
            items.add(item);
            if (item.getCantidad() != null) {
                totalPersonas += item.getCantidad().intValue();
            }
            if (item.getPrecioTotal() == null) continue;
            totalReserva = totalReserva.add(item.getPrecioTotal());
        }
        reserva.setItems(items);
        if (request.getNumeroPersonas() != null && request.getNumeroPersonas() > 0) {
            reserva.setNumeroPersonas(request.getNumeroPersonas());
        } else {
            reserva.setNumeroPersonas(Integer.valueOf(Math.max(totalPersonas, 1)));
        }
        if (totalReserva.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("El precio total debe ser mayor a 0");
        }
        reserva.setPrecioTotal(totalReserva);
        if (reserva.getDescuentoAplicado() == null) {
            reserva.setDescuentoAplicado(BigDecimal.ZERO);
        }
        String string = codigoReserva = request.getCodigoReserva() != null ? request.getCodigoReserva().trim() : null;
        if (codigoReserva == null || codigoReserva.isEmpty()) {
            codigoReserva = this.generarCodigoReserva();
        }
        reserva.setCodigoReserva(codigoReserva);
        if (this.reservaRepository.existsByEmpresaIdAndCodigoReservaAndIdNot(empresaId, codigoReserva, Long.valueOf(0L))) {
            throw new IllegalArgumentException("Error interno: c\u00f3digo de reserva duplicado, intente nuevamente");
        }
        Reserva savedReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        this.sincronizarAsignaciones(savedReserva, request.getAsignaciones());
        log.info("Reserva creada exitosamente con c\u00f3digo: {}", (Object)savedReserva.getCodigoReserva());
        return savedReserva;
    }

    /*
     * Exception decompiling
     */
    private ReservaItem construirItem(ReservaItemRequest itemRequest, Long empresaId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void prepararItemServicio(ReservaItem item, ReservaItemRequest itemRequest, Long empresaId) {
        Long servicioId = itemRequest.getServicioId();
        if (servicioId == null) {
            throw new IllegalArgumentException("Debe especificar el servicio tur\u00edstico");
        }
        ServicioTuristico servicio = (ServicioTuristico)this.servicioService.findById(servicioId).orElseThrow(() -> new IllegalArgumentException("Servicio tur\u00edstico no encontrado"));
        this.validarMismaEmpresa(empresaId, servicio.getEmpresa() != null ? servicio.getEmpresa().getIdEmpresa() : null, "servicio tur\u00edstico");
        if (!servicio.isActivo()) {
            throw new IllegalArgumentException("El servicio seleccionado no est\u00e1 activo");
        }
        if (!servicio.tieneDisponibilidad(item.getCantidad())) {
            throw new IllegalArgumentException("No hay disponibilidad para el n\u00famero de personas solicitado en el servicio " + servicio.getNombreServicio());
        }
        item.setServicio(servicio);
    }

    private void prepararItemPaquete(ReservaItem item, ReservaItemRequest itemRequest, Long empresaId) {
        Long paqueteId = itemRequest.getPaqueteId();
        if (paqueteId == null) {
            throw new IllegalArgumentException("Debe especificar el paquete tur\u00edstico");
        }
        PaqueteTuristico paquete = (PaqueteTuristico)this.paqueteService.findById(paqueteId).orElseThrow(() -> new IllegalArgumentException("Paquete tur\u00edstico no encontrado"));
        this.validarPaquetePerteneceAEmpresa(paquete, empresaId);
        if (!paquete.isActivo()) {
            throw new IllegalArgumentException("El paquete seleccionado no est\u00e1 activo");
        }
        item.setPaquete(paquete);
    }

    private void validarPaquetePerteneceAEmpresa(PaqueteTuristico paquete, Long empresaId) {
        this.validarMismaEmpresa(empresaId, paquete.getEmpresa() != null ? paquete.getEmpresa().getIdEmpresa() : null, "paquete tur\u00edstico");
        List serviciosIncluidos = paquete.getServiciosIncluidos();
        if (serviciosIncluidos == null || serviciosIncluidos.isEmpty()) {
            return;
        }
        for (PaqueteServicio paqueteServicio : serviciosIncluidos) {
            if (paqueteServicio == null) {
                throw new IllegalArgumentException("El paquete contiene registros de servicios inv\u00e1lidos");
            }
            ServicioTuristico servicio = paqueteServicio.getServicio();
            if (servicio == null) {
                throw new IllegalArgumentException("El paquete contiene un servicio no cargado. Revisa la configuraci\u00f3n del paquete.");
            }
            this.validarMismaEmpresa(empresaId, servicio.getEmpresa() != null ? servicio.getEmpresa().getIdEmpresa() : null, "servicio '" + servicio.getNombreServicio() + "' incluido en el paquete");
            if (servicio.isActivo()) continue;
            throw new IllegalArgumentException("El paquete contiene el servicio " + servicio.getNombreServicio() + " que est\u00e1 inactivo");
        }
    }

    private Date parseSqlDate(String fecha, String nombreCampo) {
        try {
            return Date.valueOf(LocalDate.parse(fecha.trim()));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("La " + nombreCampo + " no tiene un formato v\u00e1lido (yyyy-MM-dd)");
        }
    }

    private ReservaItemResponse toItemResponse(ReservaItem item) {
        ReservaItemResponse response = new ReservaItemResponse();
        response.setIdReservaItem(item.getIdReservaItem());
        response.setTipoItem(item.getTipoItem() != null ? item.getTipoItem().name() : null);
        response.setCantidad(item.getCantidad());
        response.setPrecioUnitario(item.getPrecioUnitario());
        response.setPrecioTotal(item.getPrecioTotal());
        response.setDescripcionExtra(item.getDescripcionExtra());
        if (item.getServicio() != null) {
            response.setIdServicio(item.getServicio().getIdServicio());
            response.setNombreServicio(item.getServicio().getNombreServicio());
            response.setTipoServicio(item.getServicio().getTipoServicio() != null ? item.getServicio().getTipoServicio().toString() : null);
        }
        if (item.getPaquete() != null) {
            response.setIdPaquete(item.getPaquete().getIdPaquete());
            response.setNombrePaquete(item.getPaquete().getNombrePaquete());
        }
        return response;
    }

    @Transactional(readOnly=true)
    public Optional<Reserva> findById(Long id) {
        log.debug("Buscando reserva con ID: {}", (Object)id);
        return this.reservaRepository.findByIdWithItems(id).filter(reserva -> reserva.getDeletedAt() == null).map(reserva -> {
            this.validarPertenencia(reserva);
            reserva.getItems().forEach(item -> {
                if (item.getServicio() != null) {
                    item.getServicio().getNombreServicio();
                }
                if (item.getPaquete() != null) {
                    item.getPaquete().getNombrePaquete();
                }
            });
            return reserva;
        });
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Listando reservas de empresa ID: {}", (Object)empresaFiltrada);
        return this.reservaRepository.findByEmpresaId(empresaFiltrada);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaIdAndClienteId(Long empresaId, Long clienteId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Listando reservas de empresa {} y cliente {}", (Object)empresaFiltrada, (Object)clienteId);
        Cliente cliente = (Cliente)this.clienteService.findById(clienteId).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
        this.validarMismaEmpresa(empresaFiltrada, cliente.getEmpresa() != null ? cliente.getEmpresa().getIdEmpresa() : null, "cliente");
        return this.reservaRepository.findByEmpresaIdAndClienteId(empresaFiltrada, clienteId);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaIdAndEstado(Long empresaId, Reserva.EstadoReserva estado) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Listando reservas de empresa {} con estado {}", (Object)empresaFiltrada, (Object)estado);
        return this.reservaRepository.findByEmpresaIdAndEstado(empresaFiltrada, estado);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        log.debug("Buscando reservas en empresa {} con t\u00e9rmino: {}", (Object)empresaFiltrada, (Object)busqueda);
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.reservaRepository.findByEmpresaIdOrderByCreatedAtDesc(empresaFiltrada);
        }
        return this.reservaRepository.findByEmpresaIdAndBusqueda(empresaFiltrada, busqueda.trim());
    }

    public Reserva update(Long id, ReservaUpdateRequest request) {
        log.info("Actualizando reserva ID: {}", (Object)id);
        Reserva reservaExistente = this.obtenerReservaAutorizada(id);
        if (!reservaExistente.isActiva()) {
            throw new IllegalArgumentException("No se puede modificar una reserva cancelada o completada");
        }
        if (request.getEstado() == null && request.getObservaciones() == null) {
            throw new IllegalArgumentException("Debe proporcionar al menos un campo para actualizar");
        }
        if (request.getObservaciones() != null) {
            reservaExistente.setObservaciones(request.getObservaciones());
        }
        if (request.getEstado() != null && request.getEstado() != reservaExistente.getEstado()) {
            this.validarCambioEstado(reservaExistente.getEstado(), request.getEstado());
            reservaExistente.setEstado(request.getEstado());
        }
        Reserva updatedReserva = (Reserva)this.reservaRepository.save((Object)reservaExistente);
        log.info("Reserva actualizada exitosamente: {}", (Object)updatedReserva.getIdReserva());
        return updatedReserva;
    }

    public Reserva updateDetalle(Long id, ReservaEditRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("La solicitud de edici\u00f3n es obligatoria");
        }
        log.info("Actualizando detalle de reserva ID: {}", (Object)id);
        Reserva reservaExistente = this.obtenerReservaAutorizada(id);
        if (reservaExistente.getEstado() != Reserva.EstadoReserva.Pendiente) {
            throw new IllegalStateException("Solo se pueden editar reservas en estado Pendiente");
        }
        Long empresaId = TenantContext.requireEmpresaIdOrCurrent((Long)request.getEmpresaId());
        Long empresaReserva = reservaExistente.getEmpresa() != null ? reservaExistente.getEmpresa().getIdEmpresa() : null;
        this.validarMismaEmpresa(empresaId, empresaReserva, "reserva");
        if (request.getFechaServicio() == null || request.getFechaServicio().isBlank()) {
            throw new IllegalArgumentException("La fecha de servicio es obligatoria");
        }
        List itemRequests = request.getItems();
        if (itemRequests == null || itemRequests.isEmpty()) {
            throw new IllegalArgumentException("Debe especificar al menos un item para la reserva");
        }
        Date nuevaFechaServicio = this.parseSqlDate(request.getFechaServicio(), "fecha de servicio");
        ArrayList<ReservaItem> nuevosItems = new ArrayList<ReservaItem>();
        int totalPersonas = 0;
        BigDecimal totalReserva = BigDecimal.ZERO;
        for (ReservaItemRequest itemRequest : itemRequests) {
            ReservaItem item = this.construirItem(itemRequest, empresaId);
            nuevosItems.add(item);
            if (item.getCantidad() != null) {
                totalPersonas += item.getCantidad().intValue();
            }
            if (item.getPrecioTotal() == null) continue;
            totalReserva = totalReserva.add(item.getPrecioTotal());
        }
        if (totalReserva.compareTo(BigDecimal.ZERO) <= 0) {
            throw new IllegalArgumentException("El precio total debe ser mayor a 0");
        }
        reservaExistente.setFechaServicio(nuevaFechaServicio);
        reservaExistente.setItems(nuevosItems);
        reservaExistente.setPrecioTotal(totalReserva);
        if (request.getNumeroPersonas() != null && request.getNumeroPersonas() > 0) {
            reservaExistente.setNumeroPersonas(request.getNumeroPersonas());
        } else {
            reservaExistente.setNumeroPersonas(Integer.valueOf(Math.max(totalPersonas, 1)));
        }
        if (request.getDescuentoAplicado() != null) {
            reservaExistente.setDescuentoAplicado(request.getDescuentoAplicado());
        } else if (reservaExistente.getDescuentoAplicado() == null) {
            reservaExistente.setDescuentoAplicado(BigDecimal.ZERO);
        }
        if (request.getObservaciones() != null) {
            reservaExistente.setObservaciones(request.getObservaciones());
        }
        this.validarFechas(reservaExistente);
        Reserva updatedReserva = (Reserva)this.reservaRepository.save((Object)reservaExistente);
        List asignacionesPayload = request.getAsignaciones();
        if (Boolean.TRUE.equals(request.getSincronizarAsignaciones())) {
            this.sincronizarAsignaciones(updatedReserva, asignacionesPayload != null ? asignacionesPayload : List.of());
        } else if (asignacionesPayload != null) {
            this.sincronizarAsignaciones(updatedReserva, asignacionesPayload);
        }
        log.info("Detalle de reserva {} actualizado exitosamente", (Object)updatedReserva.getIdReserva());
        return updatedReserva;
    }

    public ReservaResponse toResponse(Reserva reserva) {
        ReservaResponse response = new ReservaResponse();
        response.setIdReserva(reserva.getIdReserva());
        response.setCodigoReserva(reserva.getCodigoReserva());
        response.setFechaReserva(reserva.getFechaReserva() != null ? reserva.getFechaReserva().toString() : null);
        response.setFechaServicio(reserva.getFechaServicio() != null ? reserva.getFechaServicio().toString() : null);
        response.setNumeroPersonas(reserva.getNumeroPersonas());
        response.setPrecioTotal(reserva.getPrecioTotal());
        response.setDescuentoAplicado(reserva.getDescuentoAplicado());
        response.setEstado(reserva.getEstado().toString());
        response.setObservaciones(reserva.getObservaciones());
        response.setEvaluada(reserva.getEvaluada());
        response.setCreatedAt(reserva.getCreatedAt());
        response.setUpdatedAt(reserva.getUpdatedAt());
        if (reserva.getCliente() != null) {
            response.setIdCliente(reserva.getCliente().getIdCliente());
            response.setNombreCliente(reserva.getCliente().getNombre());
            response.setApellidoCliente(reserva.getCliente().getApellido());
            response.setEmailCliente(reserva.getCliente().getEmail());
            response.setTelefonoCliente(reserva.getCliente().getTelefono());
        }
        List items = reserva.getItems() != null ? reserva.getItems().stream().map(arg_0 -> this.toItemResponse(arg_0)).toList() : List.of();
        response.setItems(items);
        items.stream().filter(item -> "SERVICIO".equals(item.getTipoItem())).findFirst().ifPresent(item -> {
            response.setIdServicio(item.getIdServicio());
            response.setNombreServicio(item.getNombreServicio());
            response.setTipoServicio(item.getTipoServicio());
        });
        items.stream().filter(item -> "PAQUETE".equals(item.getTipoItem())).findFirst().ifPresent(item -> {
            response.setIdPaquete(item.getIdPaquete());
            response.setNombrePaquete(item.getNombrePaquete());
        });
        if (reserva.getUsuario() != null) {
            response.setIdUsuario(reserva.getUsuario().getIdUsuario());
            response.setNombreUsuario(reserva.getUsuario().getNombre());
            response.setApellidoUsuario(reserva.getUsuario().getApellido());
        }
        List<ReservaAsignacionResponse> asignaciones = this.asignacionPersonalRepository.findDetailedByReservaId(reserva.getIdReserva()).stream().map(arg_0 -> this.toAsignacionResponse(arg_0)).toList();
        response.setAsignaciones(asignaciones);
        return response;
    }

    public VoucherResponse toVoucherResponse(Voucher voucher) {
        VoucherResponse response = new VoucherResponse();
        response.setIdVoucher(voucher.getIdVoucher());
        response.setCodigoQr(voucher.getCodigoQr());
        response.setFechaEmision(voucher.getFechaEmision() != null ? voucher.getFechaEmision().toString() : null);
        response.setFechaExpiracion(voucher.getFechaExpiracion() != null ? voucher.getFechaExpiracion().toString() : null);
        response.setEstado(voucher.getEstado().toString());
        response.setCreatedAt(voucher.getCreatedAt());
        response.setUpdatedAt(voucher.getUpdatedAt());
        if (voucher.getReserva() != null) {
            Reserva reserva = voucher.getReserva();
            response.setIdReserva(reserva.getIdReserva());
            response.setCodigoReserva(reserva.getCodigoReserva());
            response.setFechaServicio(reserva.getFechaServicio() != null ? reserva.getFechaServicio().toString() : null);
            response.setNumeroPersonas(reserva.getNumeroPersonas());
            if (reserva.getCliente() != null) {
                response.setIdCliente(reserva.getCliente().getIdCliente());
                response.setNombreCliente(reserva.getCliente().getNombre());
                response.setApellidoCliente(reserva.getCliente().getApellido());
                response.setEmailCliente(reserva.getCliente().getEmail());
            }
            List items = reserva.getItems() != null ? reserva.getItems() : List.of();
            items.stream().map(arg_0 -> this.toItemResponse(arg_0)).filter(item -> "SERVICIO".equals(item.getTipoItem())).findFirst().ifPresent(item -> {
                response.setIdServicio(item.getIdServicio());
                response.setNombreServicio(item.getNombreServicio());
                response.setTipoServicio(item.getTipoServicio());
            });
        }
        return response;
    }

    private ReservaAsignacionResponse toAsignacionResponse(AsignacionPersonal asignacion) {
        ReservaAsignacionResponse response = new ReservaAsignacionResponse();
        response.setIdAsignacion(asignacion.getIdAsignacion());
        if (asignacion.getPersonal() != null) {
            response.setIdPersonal(asignacion.getPersonal().getIdPersonal());
            response.setNombrePersonal(asignacion.getPersonal().getNombre());
            response.setApellidoPersonal(asignacion.getPersonal().getApellido());
            response.setDniPersonal(asignacion.getPersonal().getDni());
            response.setTelefonoPersonal(asignacion.getPersonal().getTelefono());
            response.setEmailPersonal(asignacion.getPersonal().getEmail());
            response.setCargoPersonal(asignacion.getPersonal().getCargo() != null ? asignacion.getPersonal().getCargo().name() : null);
        }
        response.setRolAsignado(asignacion.getRolAsignado() != null ? asignacion.getRolAsignado().name() : null);
        response.setEstado(asignacion.getEstado() != null ? asignacion.getEstado().name() : null);
        response.setObservaciones(asignacion.getObservaciones());
        response.setFechaAsignacion(asignacion.getFechaAsignacion() != null ? asignacion.getFechaAsignacion().toString() : null);
        if (asignacion.getCreatedAt() != null) {
            response.setCreatedAt(LocalDateTime.ofInstant(asignacion.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        if (asignacion.getUpdatedAt() != null) {
            response.setUpdatedAt(LocalDateTime.ofInstant(asignacion.getUpdatedAt().toInstant(), ZoneId.systemDefault()));
        }
        return response;
    }

    @Transactional(readOnly=true)
    public List<ReservaAsignacionResponse> obtenerAsignaciones(Long reservaId) {
        Reserva reserva = this.obtenerReservaAutorizada(reservaId);
        return this.asignacionPersonalRepository.findDetailedByReservaId(reserva.getIdReserva()).stream().map(arg_0 -> this.toAsignacionResponse(arg_0)).toList();
    }

    public Reserva actualizarAsignaciones(Long reservaId, ReservaAsignacionSyncRequest request) {
        Reserva reserva = this.obtenerReservaAutorizada(reservaId);
        this.sincronizarAsignaciones(reserva, request != null ? request.getAsignaciones() : null);
        return this.reservaRepository.findByIdWithItems(reservaId).orElse(reserva);
    }

    private void sincronizarAsignaciones(Reserva reserva, List<ReservaAsignacionPayload> asignacionesPayload) {
        if (asignacionesPayload == null) {
            return;
        }
        if (reserva.getIdReserva() == null) {
            throw new IllegalStateException("La reserva debe existir antes de gestionar asignaciones");
        }
        if (!this.puedeActualizarAsignaciones(reserva.getEstado())) {
            throw new IllegalStateException("Solo se pueden gestionar asignaciones cuando la reserva est\u00e1 en estado Pendiente o Pagada");
        }
        this.validarAsignacionesDuplicadas(asignacionesPayload);
        Date fechaServicio = reserva.getFechaServicio();
        List existentes = this.asignacionPersonalRepository.findByReservaId(reserva.getIdReserva());
        Map<Long, AsignacionPersonal> existentesPorId = existentes.stream().filter(asignacion -> asignacion.getIdAsignacion() != null).collect(Collectors.toMap(AsignacionPersonal::getIdAsignacion, asignacion -> asignacion, (primera, segunda) -> primera));
        Set idsSolicitados = asignacionesPayload.stream().map(ReservaAsignacionPayload::getIdAsignacion).filter(Objects::nonNull).collect(Collectors.toSet());
        for (AsignacionPersonal existente : existentes) {
            if (existente.getIdAsignacion() == null || idsSolicitados.contains(existente.getIdAsignacion())) continue;
            this.asignacionPersonalService.delete(existente.getIdAsignacion());
        }
        for (ReservaAsignacionPayload payload : asignacionesPayload) {
            Date fechaAsignacion = this.parseFechaAsignacion(payload.getFechaAsignacion(), fechaServicio);
            if (payload.getIdAsignacion() != null) {
                AsignacionPersonal existente = existentesPorId.get(payload.getIdAsignacion());
                if (existente == null) {
                    throw new IllegalArgumentException("Asignaci\u00f3n no encontrada para la reserva");
                }
                if (!existente.getReserva().getIdReserva().equals(reserva.getIdReserva())) {
                    throw new IllegalArgumentException("La asignaci\u00f3n no pertenece a la reserva");
                }
                if (!fechaAsignacion.equals(reserva.getFechaServicio())) {
                    throw new IllegalArgumentException("La fecha de asignaci\u00f3n debe coincidir con la fecha del servicio");
                }
                boolean requiereActualizacion = !Objects.equals(existente.getPersonal().getIdPersonal(), payload.getIdPersonal()) || !Objects.equals(this.normalizarObservacion(existente.getObservaciones()), this.normalizarObservacion(payload.getObservaciones()));
                AsignacionPersonal asignacionPersistida = existente;
                if (requiereActualizacion) {
                    AsignacionPersonalUpdateRequest updateRequest = new AsignacionPersonalUpdateRequest();
                    updateRequest.setIdPersonal(payload.getIdPersonal());
                    updateRequest.setObservaciones(payload.getObservaciones());
                    asignacionPersistida = this.asignacionPersonalService.update(existente.getIdAsignacion(), updateRequest);
                }
                if (Objects.equals(asignacionPersistida.getFechaAsignacion(), fechaAsignacion)) continue;
                if (this.asignacionPersonalRepository.existsByPersonalAndFecha(payload.getIdPersonal(), fechaAsignacion)) {
                    throw new IllegalArgumentException("El personal ya est\u00e1 asignado en esta fecha");
                }
                asignacionPersistida.setFechaAsignacion(fechaAsignacion);
                this.asignacionPersonalRepository.save((Object)asignacionPersistida);
                continue;
            }
            AsignacionPersonalRequest nuevo = new AsignacionPersonalRequest();
            nuevo.setIdPersonal(payload.getIdPersonal());
            nuevo.setIdReserva(reserva.getIdReserva());
            nuevo.setFechaAsignacion(fechaAsignacion);
            nuevo.setObservaciones(payload.getObservaciones());
            this.asignacionPersonalService.create(nuevo);
        }
    }

    public Reserva cancel(Long id) {
        log.info("Cancelando reserva ID: {}", (Object)id);
        Reserva reserva = this.obtenerReservaAutorizada(id);
        if (!reserva.puedeCancelarse()) {
            throw new IllegalArgumentException("La reserva no puede ser cancelada");
        }
        reserva.setEstado(Reserva.EstadoReserva.Cancelada);
        Reserva cancelledReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        this.actualizarEstadoAsignaciones(cancelledReserva, AsignacionPersonal.EstadoAsignacion.Cancelado);
        log.info("Reserva cancelada exitosamente: {}", (Object)cancelledReserva.getIdReserva());
        return cancelledReserva;
    }

    public void delete(Long id) {
        log.info("Eliminando reserva ID: {} (soft delete)", (Object)id);
        Reserva reserva = this.obtenerReservaAutorizada(id);
        if (reserva.getEstado() == Reserva.EstadoReserva.Completada) {
            throw new IllegalArgumentException("No se puede eliminar una reserva completada");
        }
        reserva.setDeletedAt(LocalDateTime.now());
        this.reservaRepository.save((Object)reserva);
        log.info("Reserva eliminada exitosamente: {}", (Object)id);
    }

    public Reserva completar(Long id) {
        log.info("Completando reserva ID {}", (Object)id);
        Reserva reserva = this.obtenerReservaAutorizada(id);
        if (reserva.getEstado() != Reserva.EstadoReserva.Pagada) {
            throw new IllegalArgumentException("Solo se pueden completar reservas pagadas");
        }
        reserva.setEstado(Reserva.EstadoReserva.Completada);
        Reserva completedReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        this.actualizarEstadoAsignaciones(completedReserva, AsignacionPersonal.EstadoAsignacion.Completado);
        log.info("Reserva completada exitosamente: {}", (Object)completedReserva.getIdReserva());
        return completedReserva;
    }

    private void actualizarEstadoAsignaciones(Reserva reserva, AsignacionPersonal.EstadoAsignacion nuevoEstado) {
        if (reserva == null || reserva.getIdReserva() == null) {
            return;
        }
        List asignaciones = this.asignacionPersonalRepository.findByReservaId(reserva.getIdReserva());
        if (asignaciones.isEmpty()) {
            return;
        }
        boolean requiereActualizacion = false;
        for (AsignacionPersonal asignacion : asignaciones) {
            if (asignacion.getEstado() == nuevoEstado) continue;
            asignacion.setEstado(nuevoEstado);
            requiereActualizacion = true;
        }
        if (requiereActualizacion) {
            this.asignacionPersonalRepository.saveAll((Iterable)asignaciones);
        }
    }

    public Reserva marcarComoEvaluada(Long id) {
        log.info("Marcando reserva ID {} como evaluada", (Object)id);
        Reserva reserva = this.obtenerReservaAutorizada(id);
        if (!reserva.puedeEvaluarse()) {
            throw new IllegalArgumentException("La reserva no puede ser evaluada");
        }
        reserva.setEvaluada(Boolean.valueOf(true));
        Reserva evaluatedReserva = (Reserva)this.reservaRepository.save((Object)reserva);
        log.info("Reserva marcada como evaluada: {}", (Object)evaluatedReserva.getIdReserva());
        return evaluatedReserva;
    }

    private Reserva obtenerReservaAutorizada(Long id) {
        Reserva reserva = (Reserva)this.reservaRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Reserva no encontrada"));
        if (reserva.getDeletedAt() != null) {
            throw new IllegalArgumentException("Reserva no encontrada");
        }
        this.validarPertenencia(reserva);
        return reserva;
    }

    private boolean esSuperAdmin() {
        return TenantContext.isSuperAdmin();
    }

    private void validarMismaEmpresa(Long empresaEsperada, Long empresaRelacionada, String recurso) {
        if (empresaEsperada == null || empresaRelacionada == null || !empresaEsperada.equals(empresaRelacionada)) {
            throw new IllegalArgumentException("El " + recurso + " no pertenece a la empresa actual");
        }
    }

    private Empresa obtenerEmpresaActiva(Long empresaId) {
        return (Empresa)this.empresaRepository.findActivaById(empresaId).orElseThrow(() -> new IllegalArgumentException("Empresa no encontrada"));
    }

    private Usuario obtenerUsuarioActual(Empresa empresa) {
        Long usuarioId = TenantContext.requireUserId();
        Usuario usuario = (Usuario)this.usuarioRepository.findById((Object)usuarioId).orElseThrow(() -> new IllegalArgumentException("Usuario autenticado no encontrado"));
        if (!this.esSuperAdmin()) {
            Long empresaUsuario;
            Long l = empresaUsuario = usuario.getEmpresa() != null ? usuario.getEmpresa().getIdEmpresa() : null;
            if (!empresa.getIdEmpresa().equals(empresaUsuario)) {
                throw new IllegalArgumentException("El usuario autenticado no pertenece a la empresa actual");
            }
        }
        return usuario;
    }

    private void validarPertenencia(Reserva reserva) {
        if (!this.esSuperAdmin()) {
            Long empresaReserva;
            Long empresaActual = TenantContext.requireEmpresaId();
            Long l = empresaReserva = reserva.getEmpresa() != null ? reserva.getEmpresa().getIdEmpresa() : null;
            if (!empresaActual.equals(empresaReserva)) {
                throw new IllegalArgumentException("La reserva no pertenece a la empresa actual");
            }
        }
    }

    private String generarCodigoReserva() {
        return "RES-" + UUID.randomUUID().toString().substring(0, 8).toUpperCase();
    }

    private void validarFechas(Reserva reserva) {
        LocalDate hoy = LocalDate.now();
        LocalDate fechaServicio = reserva.getFechaServicio().toLocalDate();
        if (fechaServicio.isBefore(hoy)) {
            throw new IllegalArgumentException("La fecha de servicio no puede ser anterior a hoy");
        }
        LocalDate fechaReserva = reserva.getFechaReserva().toLocalDate();
        if (fechaReserva.isAfter(hoy.plusYears(1L))) {
            throw new IllegalArgumentException("La fecha de reserva no puede ser m\u00e1s de 1 a\u00f1o en el futuro");
        }
    }

    private Date parseFechaAsignacion(String fechaAsignacion, Date fechaServicio) {
        if (fechaServicio == null) {
            throw new IllegalArgumentException("La fecha del servicio es obligatoria para asignar personal");
        }
        if (fechaAsignacion == null || fechaAsignacion.isBlank()) {
            return fechaServicio;
        }
        Date parsed = this.parseSqlDate(fechaAsignacion, "fecha de asignaci\u00f3n");
        if (!parsed.equals(fechaServicio)) {
            throw new IllegalArgumentException("La fecha de asignaci\u00f3n debe coincidir con la fecha del servicio");
        }
        return parsed;
    }

    private void validarAsignacionesDuplicadas(List<ReservaAsignacionPayload> asignaciones) {
        if (asignaciones == null || asignaciones.isEmpty()) {
            return;
        }
        HashSet<Long> personalIds = new HashSet<Long>();
        for (ReservaAsignacionPayload payload : asignaciones) {
            if (personalIds.add(payload.getIdPersonal())) continue;
            throw new IllegalArgumentException("El personal con ID " + String.valueOf(payload.getIdPersonal()) + " est\u00e1 duplicado en la solicitud");
        }
    }

    private boolean puedeActualizarAsignaciones(Reserva.EstadoReserva estado) {
        return estado == Reserva.EstadoReserva.Pendiente || estado == Reserva.EstadoReserva.Pagada;
    }

    private String normalizarObservacion(String observacion) {
        if (observacion == null) {
            return null;
        }
        String valor = observacion.trim();
        return valor.isEmpty() ? null : valor;
    }

    /*
     * Exception decompiling
     */
    private void validarCambioEstado(Reserva.EstadoReserva estadoActual, Reserva.EstadoReserva estadoNuevo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Reserva actualizarEstadoFinanciero(Reserva reserva, Reserva.EstadoReserva nuevoEstado) {
        this.validarPertenencia(reserva);
        if (reserva.getDeletedAt() != null) {
            throw new IllegalArgumentException("Reserva no encontrada");
        }
        this.validarCambioEstado(reserva.getEstado(), nuevoEstado);
        reserva.setEstado(nuevoEstado);
        return (Reserva)this.reservaRepository.save((Object)reserva);
    }

    public Reserva actualizarEstadoFinanciero(Long reservaId, Reserva.EstadoReserva nuevoEstado) {
        Reserva reserva = this.obtenerReservaAutorizada(reservaId);
        return this.actualizarEstadoFinanciero(reserva, nuevoEstado);
    }

    @Transactional(readOnly=true)
    public Long countByEmpresaId(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        return this.reservaRepository.countByEmpresaId(empresaFiltrada);
    }

    @Transactional(readOnly=true)
    public List<Reserva> findReservasProximas(Long empresaId) {
        Long empresaFiltrada = TenantContext.requireEmpresaIdOrCurrent((Long)empresaId);
        Date hoy = Date.valueOf(LocalDate.now());
        Date enUnaSemana = Date.valueOf(LocalDate.now().plusDays(7L));
        return this.reservaRepository.findReservasProximas(empresaFiltrada, hoy, enUnaSemana);
    }

    @Generated
    public ReservaService(ReservaRepository reservaRepository, ClienteService clienteService, ServicioTuristicoService servicioService, PaqueteTuristicoService paqueteService, EmpresaRepository empresaRepository, UsuarioRepository usuarioRepository, AsignacionPersonalService asignacionPersonalService, AsignacionPersonalRepository asignacionPersonalRepository) {
        this.reservaRepository = reservaRepository;
        this.clienteService = clienteService;
        this.servicioService = servicioService;
        this.paqueteService = paqueteService;
        this.empresaRepository = empresaRepository;
        this.usuarioRepository = usuarioRepository;
        this.asignacionPersonalService = asignacionPersonalService;
        this.asignacionPersonalRepository = asignacionPersonalRepository;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$ReservaItem$TipoItem() {
        if ($SWITCH_TABLE$com$sistema$turistico$entity$ReservaItem$TipoItem != null) {
            return $SWITCH_TABLE$com$sistema$turistico$entity$ReservaItem$TipoItem;
        }
        int[] nArray = new int[ReservaItem.TipoItem.values().length];
        try {
            nArray[ReservaItem.TipoItem.PAQUETE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ReservaItem.TipoItem.SERVICIO.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sistema$turistico$entity$ReservaItem$TipoItem = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva() {
        if ($SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva != null) {
            return $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva;
        }
        int[] nArray = new int[Reserva.EstadoReserva.values().length];
        try {
            nArray[Reserva.EstadoReserva.Cancelada.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Completada.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Confirmada.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Pagada.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.PagoParcial.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Reserva.EstadoReserva.Pendiente.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sistema$turistico$entity$Reserva$EstadoReserva = nArray;
        return nArray;
    }
}

