/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresas"})
@Tag(name="Empresas", description="Endpoints para gesti\u00f3n de empresas")
public class EmpresaController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmpresaController.class);

    @GetMapping
    @PreAuthorize(value="hasAnyRole('ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Listar empresas", description="Obtiene la lista de empresas (solo para administradores)")
    public ResponseEntity<Map<String, Object>> listarEmpresas() {
        try {
            log.info("Listando empresas para usuario autorizado");
            ArrayList empresas = new ArrayList();
            HashMap<String, Object> empresa1 = new HashMap<String, Object>();
            empresa1.put("id", 1);
            empresa1.put("nombre", "Empresa Demo Tur\u00edstica");
            empresa1.put("ruc", "12345678901");
            empresa1.put("email", "admin@demoturistica.com");
            empresa1.put("estado", "Activa");
            empresas.add(empresa1);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Empresas obtenidas exitosamente");
            response.put("data", empresas);
            response.put("total", empresas.size());
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Error al listar empresas", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @Generated
    public EmpresaController() {
    }
}

