/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.controller;

import com.sistema.turistico.dto.VoucherResponse;
import com.sistema.turistico.dto.VoucherUpdateRequest;
import com.sistema.turistico.entity.Voucher;
import com.sistema.turistico.repository.VoucherRepository;
import com.sistema.turistico.service.ReservaService;
import com.sistema.turistico.util.JwtUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/vouchers"})
@Tag(name="Vouchers", description="Endpoints para gesti\u00f3n de vouchers")
public class VoucherController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherController.class);
    private final VoucherRepository voucherRepository;
    private final ReservaService reservaService;
    private final JwtUtil jwtUtil;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$Voucher$EstadoVoucher;

    private String getJwtFromRequest(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }

    @GetMapping
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Listar vouchers", description="Obtiene la lista de vouchers con filtros opcionales")
    public ResponseEntity<Map<String, Object>> listarVouchers(HttpServletRequest request, @RequestParam(required=false) String busqueda, @RequestParam(required=false) Voucher.EstadoVoucher estado, @RequestParam(required=false, defaultValue="1") int page, @RequestParam(required=false, defaultValue="10") int size) {
        try {
            String token = this.getJwtFromRequest(request);
            Long empresaId = this.jwtUtil.getEmpresaIdFromToken(token);
            log.info("Listando vouchers de empresa {} con filtros - p\u00e1gina: {}, tama\u00f1o: {}", new Object[]{empresaId, page, size});
            List<Voucher> vouchers = estado != null ? this.voucherRepository.findByReserva_Empresa_IdEmpresa(empresaId).stream().filter(v -> v.getEstado() == estado).toList() : this.voucherRepository.findByReserva_Empresa_IdEmpresa(empresaId);
            int startIndex = (page - 1) * size;
            int endIndex = Math.min(startIndex + size, vouchers.size());
            List<Voucher> vouchersPaginadas = vouchers.subList(startIndex, endIndex);
            List<VoucherResponse> vouchersResponse = vouchersPaginadas.stream().map(arg_0 -> ((ReservaService)this.reservaService).toVoucherResponse(arg_0)).toList();
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Vouchers obtenidos exitosamente");
            response.put("data", vouchersResponse);
            response.put("total", vouchers.size());
            response.put("page", page);
            response.put("size", size);
            response.put("totalPages", (int)Math.ceil((double)vouchers.size() / (double)size));
            return ResponseEntity.ok(response);
        }
        catch (Exception e) {
            log.error("Error al listar vouchers", (Throwable)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @GetMapping(value={"/{codigoQr}"})
    @Operation(summary="Obtener voucher por QR", description="Obtiene un voucher espec\u00edfico por su c\u00f3digo QR")
    public ResponseEntity<Map<String, Object>> obtenerVoucherPorQr(@PathVariable String codigoQr) {
        try {
            log.info("Obteniendo voucher con c\u00f3digo QR: {}", (Object)codigoQr);
            Voucher voucher = (Voucher)this.voucherRepository.findByCodigoQr(codigoQr).orElseThrow(() -> new IllegalArgumentException("Voucher no encontrado"));
            VoucherResponse voucherResponse = this.reservaService.toVoucherResponse(voucher);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher obtenido exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Voucher no encontrado: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.notFound().build();
        }
        catch (Exception e) {
            log.error("Error al obtener voucher con c\u00f3digo QR: {}", (Object)codigoQr, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @PutMapping(value={"/{codigoQr}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Actualizar voucher", description="Actualiza el estado de un voucher espec\u00edfico")
    public ResponseEntity<Map<String, Object>> actualizarVoucher(@PathVariable String codigoQr, @RequestBody VoucherUpdateRequest request) {
        try {
            Voucher.EstadoVoucher nuevoEstado;
            log.info("Actualizando voucher con c\u00f3digo QR: {}", (Object)codigoQr);
            Voucher voucher = (Voucher)this.voucherRepository.findByCodigoQr(codigoQr).orElseThrow(() -> new IllegalArgumentException("Voucher no encontrado"));
            if (request.getEstado() == null) {
                throw new IllegalArgumentException("Debe proporcionar el estado para actualizar");
            }
            String estadoStr = request.getEstado();
            if ("Canjeado".equals(estadoStr)) {
                estadoStr = "Usado";
            }
            try {
                nuevoEstado = Voucher.EstadoVoucher.valueOf((String)estadoStr);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Estado no v\u00e1lido: " + request.getEstado());
            }
            if (voucher.getEstado() == nuevoEstado) {
                throw new IllegalArgumentException("El estado ya es " + String.valueOf(nuevoEstado));
            }
            this.validarCambioEstado(voucher.getEstado(), nuevoEstado);
            voucher.setEstado(nuevoEstado);
            Voucher voucherActualizado = (Voucher)this.voucherRepository.save((Object)voucher);
            VoucherResponse voucherResponse = this.reservaService.toVoucherResponse(voucherActualizado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher actualizado exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error de validaci\u00f3n al actualizar voucher: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al actualizar voucher con c\u00f3digo QR: {}", (Object)codigoQr, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    @DeleteMapping(value={"/{codigoQr}"})
    @PreAuthorize(value="hasAnyRole('EMPLEADO', 'ADMINISTRADOR', 'SUPERADMINISTRADOR')")
    @Operation(summary="Cancelar voucher", description="Cancela un voucher cambiando su estado a 'Cancelado'")
    public ResponseEntity<Map<String, Object>> cancelarVoucher(@PathVariable String codigoQr) {
        try {
            log.info("Cancelando voucher con c\u00f3digo QR: {}", (Object)codigoQr);
            Voucher voucher = (Voucher)this.voucherRepository.findByCodigoQr(codigoQr).orElseThrow(() -> new IllegalArgumentException("Voucher no encontrado"));
            if (voucher.getEstado() == Voucher.EstadoVoucher.Usado) {
                throw new IllegalArgumentException("No se puede cancelar un voucher usado");
            }
            if (voucher.getEstado() == Voucher.EstadoVoucher.Expirado) {
                throw new IllegalArgumentException("No se puede cancelar un voucher expirado");
            }
            if (voucher.getEstado() == Voucher.EstadoVoucher.Cancelado) {
                throw new IllegalArgumentException("El voucher ya est\u00e1 cancelado");
            }
            voucher.setEstado(Voucher.EstadoVoucher.Cancelado);
            Voucher voucherCancelado = (Voucher)this.voucherRepository.save((Object)voucher);
            VoucherResponse voucherResponse = this.reservaService.toVoucherResponse(voucherCancelado);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("success", true);
            response.put("message", "Voucher cancelado exitosamente");
            response.put("data", voucherResponse);
            return ResponseEntity.ok(response);
        }
        catch (IllegalArgumentException e) {
            log.warn("Error al cancelar voucher: {}", (Object)e.getMessage());
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", e.getMessage());
            return ResponseEntity.badRequest().body(errorResponse);
        }
        catch (Exception e) {
            log.error("Error al cancelar voucher con c\u00f3digo QR: {}", (Object)codigoQr, (Object)e);
            HashMap<String, Object> errorResponse = new HashMap<String, Object>();
            errorResponse.put("success", false);
            errorResponse.put("message", "Error interno del servidor");
            return ResponseEntity.internalServerError().body(errorResponse);
        }
    }

    /*
     * Exception decompiling
     */
    private void validarCambioEstado(Voucher.EstadoVoucher estadoActual, Voucher.EstadoVoucher estadoNuevo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Generated
    public VoucherController(VoucherRepository voucherRepository, ReservaService reservaService, JwtUtil jwtUtil) {
        this.voucherRepository = voucherRepository;
        this.reservaService = reservaService;
        this.jwtUtil = jwtUtil;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$sistema$turistico$entity$Voucher$EstadoVoucher() {
        if ($SWITCH_TABLE$com$sistema$turistico$entity$Voucher$EstadoVoucher != null) {
            return $SWITCH_TABLE$com$sistema$turistico$entity$Voucher$EstadoVoucher;
        }
        int[] nArray = new int[Voucher.EstadoVoucher.values().length];
        try {
            nArray[Voucher.EstadoVoucher.Cancelado.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Voucher.EstadoVoucher.Emitido.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Voucher.EstadoVoucher.Expirado.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Voucher.EstadoVoucher.Usado.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$sistema$turistico$entity$Voucher$EstadoVoucher = nArray;
        return nArray;
    }
}

