/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Reserva;
import com.sistema.turistico.entity.Usuario;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="pagos_reservas")
public class PagoReserva {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_pago")
    private Long idPago;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_reserva", nullable=false)
    private Reserva reserva;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_usuario", nullable=false)
    private Usuario usuario;
    @NotNull
    @DecimalMin(value="0.01", message="El monto debe ser mayor a 0")
    @Digits(integer=10, fraction=2)
    @Column(name="monto_pagado", nullable=false, precision=10, scale=2)
    private @NotNull @DecimalMin(value="0.01", message="El monto debe ser mayor a 0") @Digits(integer=10, fraction=2) BigDecimal montoPagado;
    @Column(name="metodo_pago", nullable=false, length=50)
    private String metodoPago;
    @Column(name="numero_operacion", length=100)
    private String numeroOperacion;
    @Column(name="comprobante", length=100)
    private String comprobante;
    @Column(name="fecha_pago", nullable=false)
    private LocalDate fechaPago;
    @Column(name="observaciones", columnDefinition="TEXT")
    private String observaciones;
    @Column(name="estado", nullable=false)
    private Boolean estado = Boolean.TRUE;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    @Generated
    public Long getIdPago() {
        return this.idPago;
    }

    @Generated
    public Reserva getReserva() {
        return this.reserva;
    }

    @Generated
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Generated
    public BigDecimal getMontoPagado() {
        return this.montoPagado;
    }

    @Generated
    public String getMetodoPago() {
        return this.metodoPago;
    }

    @Generated
    public String getNumeroOperacion() {
        return this.numeroOperacion;
    }

    @Generated
    public String getComprobante() {
        return this.comprobante;
    }

    @Generated
    public LocalDate getFechaPago() {
        return this.fechaPago;
    }

    @Generated
    public String getObservaciones() {
        return this.observaciones;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setIdPago(Long idPago) {
        this.idPago = idPago;
    }

    @Generated
    public void setReserva(Reserva reserva) {
        this.reserva = reserva;
    }

    @Generated
    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setMontoPagado(BigDecimal montoPagado) {
        this.montoPagado = montoPagado;
    }

    @Generated
    public void setMetodoPago(String metodoPago) {
        this.metodoPago = metodoPago;
    }

    @Generated
    public void setNumeroOperacion(String numeroOperacion) {
        this.numeroOperacion = numeroOperacion;
    }

    @Generated
    public void setComprobante(String comprobante) {
        this.comprobante = comprobante;
    }

    @Generated
    public void setFechaPago(LocalDate fechaPago) {
        this.fechaPago = fechaPago;
    }

    @Generated
    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public String toString() {
        return "PagoReserva(idPago=" + String.valueOf(this.getIdPago()) + ", reserva=" + String.valueOf(this.getReserva()) + ", usuario=" + String.valueOf(this.getUsuario()) + ", montoPagado=" + String.valueOf(this.getMontoPagado()) + ", metodoPago=" + this.getMetodoPago() + ", numeroOperacion=" + this.getNumeroOperacion() + ", comprobante=" + this.getComprobante() + ", fechaPago=" + String.valueOf(this.getFechaPago()) + ", observaciones=" + this.getObservaciones() + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public PagoReserva() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagoReserva)) {
            return false;
        }
        PagoReserva other = (PagoReserva)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idPago = this.getIdPago();
        Long other$idPago = other.getIdPago();
        return !(this$idPago == null ? other$idPago != null : !((Object)this$idPago).equals(other$idPago));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagoReserva;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idPago = this.getIdPago();
        result = result * 59 + ($idPago == null ? 43 : ((Object)$idPago).hashCode());
        return result;
    }
}

