/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.entity;

import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.ServicioTuristico;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="servicios_turisticos", indexes={@Index(name="idx_servicios_empresa", columnList="id_empresa"), @Index(name="fk_servicio_categoria", columnList="id_categoria"), @Index(name="idx_servicios_tipo", columnList="tipo_servicio"), @Index(name="idx_servicios_estado", columnList="estado")})
public class ServicioTuristico {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id_servicio")
    private Long idServicio;
    @NotNull(message="La empresa es obligatoria")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_empresa", nullable=false)
    private @NotNull(message="La empresa es obligatoria") Empresa empresa;
    @Column(name="id_proveedor")
    private Long idProveedor;
    @Column(name="id_categoria")
    private Long idCategoria;
    @NotNull(message="El tipo de servicio es obligatorio")
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_servicio", nullable=false, columnDefinition="ENUM('Tour','Hotel','Transporte','Entrada/Atractivo')")
    private // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull(message="El tipo de servicio es obligatorio") ServicioTuristico.TipoServicio tipoServicio;
    @NotBlank(message="El nombre del servicio es obligatorio")
    @Size(max=255, message="El nombre no puede exceder 255 caracteres")
    @Column(name="nombre_servicio", nullable=false, length=255)
    private @NotBlank(message="El nombre del servicio es obligatorio") @Size(max=255, message="El nombre no puede exceder 255 caracteres") String nombreServicio;
    @Column(name="descripcion", columnDefinition="TEXT")
    private String descripcion;
    @Size(max=255, message="La ubicaci\u00f3n no puede exceder 255 caracteres")
    @Column(name="ubicacion_destino", length=255)
    private @Size(max=255, message="La ubicaci\u00f3n no puede exceder 255 caracteres") String ubicacionDestino;
    @Size(max=100, message="La duraci\u00f3n no puede exceder 100 caracteres")
    @Column(name="duracion", length=100)
    private @Size(max=100, message="La duraci\u00f3n no puede exceder 100 caracteres") String duracion;
    @NotNull(message="La capacidad m\u00e1xima es obligatoria")
    @Min(value=1L, message="La capacidad m\u00e1xima debe ser al menos 1")
    @Column(name="capacidad_maxima", nullable=false)
    private @NotNull(message="La capacidad m\u00e1xima es obligatoria") @Min(value=1L, message="La capacidad m\u00e1xima debe ser al menos 1") Integer capacidadMaxima;
    @NotNull(message="El precio base es obligatorio")
    @DecimalMin(value="0.01", message="El precio base debe ser mayor a 0")
    @Digits(integer=10, fraction=2, message="El precio base debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales")
    @Column(name="precio_base", nullable=false, precision=10, scale=2)
    private @NotNull(message="El precio base es obligatorio") @DecimalMin(value="0.01", message="El precio base debe ser mayor a 0") @Digits(integer=10, fraction=2, message="El precio base debe tener m\u00e1ximo 10 d\u00edgitos enteros y 2 decimales") BigDecimal precioBase;
    @Column(name="incluye", columnDefinition="TEXT")
    private String incluye;
    @Column(name="no_incluye", columnDefinition="TEXT")
    private String noIncluye;
    @Column(name="requisitos", columnDefinition="TEXT")
    private String requisitos;
    @Column(name="politicas_especiales", columnDefinition="TEXT")
    private String politicasEspeciales;
    @Column(name="imagenes", columnDefinition="LONGTEXT")
    private String imagenes;
    @Column(name="itinerario", columnDefinition="TEXT")
    private String itinerario;
    @NotNull(message="El estado es obligatorio")
    @Column(name="estado", nullable=false, columnDefinition="TINYINT(1) DEFAULT 1")
    private @NotNull(message="El estado es obligatorio") Boolean estado = true;
    @CreationTimestamp
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @UpdateTimestamp
    @Column(name="updated_at", nullable=false)
    private LocalDateTime updatedAt;
    @Column(name="deleted_at")
    private LocalDateTime deletedAt;

    public boolean isActivo() {
        return this.estado != false && this.deletedAt == null;
    }

    public boolean tieneDisponibilidad(Integer personasRequeridas) {
        return this.isActivo() && this.capacidadMaxima >= personasRequeridas;
    }

    public BigDecimal calcularPrecioTotal(Integer personas) {
        return this.precioBase.multiply(BigDecimal.valueOf(personas.intValue()));
    }

    @Generated
    public Long getIdServicio() {
        return this.idServicio;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Long getIdProveedor() {
        return this.idProveedor;
    }

    @Generated
    public Long getIdCategoria() {
        return this.idCategoria;
    }

    @Generated
    public TipoServicio getTipoServicio() {
        return this.tipoServicio;
    }

    @Generated
    public String getNombreServicio() {
        return this.nombreServicio;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public String getUbicacionDestino() {
        return this.ubicacionDestino;
    }

    @Generated
    public String getDuracion() {
        return this.duracion;
    }

    @Generated
    public Integer getCapacidadMaxima() {
        return this.capacidadMaxima;
    }

    @Generated
    public BigDecimal getPrecioBase() {
        return this.precioBase;
    }

    @Generated
    public String getIncluye() {
        return this.incluye;
    }

    @Generated
    public String getNoIncluye() {
        return this.noIncluye;
    }

    @Generated
    public String getRequisitos() {
        return this.requisitos;
    }

    @Generated
    public String getPoliticasEspeciales() {
        return this.politicasEspeciales;
    }

    @Generated
    public String getImagenes() {
        return this.imagenes;
    }

    @Generated
    public String getItinerario() {
        return this.itinerario;
    }

    @Generated
    public Boolean getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public LocalDateTime getDeletedAt() {
        return this.deletedAt;
    }

    @Generated
    public void setIdServicio(Long idServicio) {
        this.idServicio = idServicio;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setIdProveedor(Long idProveedor) {
        this.idProveedor = idProveedor;
    }

    @Generated
    public void setIdCategoria(Long idCategoria) {
        this.idCategoria = idCategoria;
    }

    @Generated
    public void setTipoServicio(TipoServicio tipoServicio) {
        this.tipoServicio = tipoServicio;
    }

    @Generated
    public void setNombreServicio(String nombreServicio) {
        this.nombreServicio = nombreServicio;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setUbicacionDestino(String ubicacionDestino) {
        this.ubicacionDestino = ubicacionDestino;
    }

    @Generated
    public void setDuracion(String duracion) {
        this.duracion = duracion;
    }

    @Generated
    public void setCapacidadMaxima(Integer capacidadMaxima) {
        this.capacidadMaxima = capacidadMaxima;
    }

    @Generated
    public void setPrecioBase(BigDecimal precioBase) {
        this.precioBase = precioBase;
    }

    @Generated
    public void setIncluye(String incluye) {
        this.incluye = incluye;
    }

    @Generated
    public void setNoIncluye(String noIncluye) {
        this.noIncluye = noIncluye;
    }

    @Generated
    public void setRequisitos(String requisitos) {
        this.requisitos = requisitos;
    }

    @Generated
    public void setPoliticasEspeciales(String politicasEspeciales) {
        this.politicasEspeciales = politicasEspeciales;
    }

    @Generated
    public void setImagenes(String imagenes) {
        this.imagenes = imagenes;
    }

    @Generated
    public void setItinerario(String itinerario) {
        this.itinerario = itinerario;
    }

    @Generated
    public void setEstado(Boolean estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setDeletedAt(LocalDateTime deletedAt) {
        this.deletedAt = deletedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServicioTuristico)) {
            return false;
        }
        ServicioTuristico other = (ServicioTuristico)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$idServicio = this.getIdServicio();
        Long other$idServicio = other.getIdServicio();
        if (this$idServicio == null ? other$idServicio != null : !((Object)this$idServicio).equals(other$idServicio)) {
            return false;
        }
        Long this$idProveedor = this.getIdProveedor();
        Long other$idProveedor = other.getIdProveedor();
        if (this$idProveedor == null ? other$idProveedor != null : !((Object)this$idProveedor).equals(other$idProveedor)) {
            return false;
        }
        Long this$idCategoria = this.getIdCategoria();
        Long other$idCategoria = other.getIdCategoria();
        if (this$idCategoria == null ? other$idCategoria != null : !((Object)this$idCategoria).equals(other$idCategoria)) {
            return false;
        }
        Integer this$capacidadMaxima = this.getCapacidadMaxima();
        Integer other$capacidadMaxima = other.getCapacidadMaxima();
        if (this$capacidadMaxima == null ? other$capacidadMaxima != null : !((Object)this$capacidadMaxima).equals(other$capacidadMaxima)) {
            return false;
        }
        Boolean this$estado = this.getEstado();
        Boolean other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !((Object)this$estado).equals(other$estado)) {
            return false;
        }
        Empresa this$empresa = this.getEmpresa();
        Empresa other$empresa = other.getEmpresa();
        if (this$empresa == null ? other$empresa != null : !this$empresa.equals(other$empresa)) {
            return false;
        }
        TipoServicio this$tipoServicio = this.getTipoServicio();
        TipoServicio other$tipoServicio = other.getTipoServicio();
        if (this$tipoServicio == null ? other$tipoServicio != null : !this$tipoServicio.equals(other$tipoServicio)) {
            return false;
        }
        String this$nombreServicio = this.getNombreServicio();
        String other$nombreServicio = other.getNombreServicio();
        if (this$nombreServicio == null ? other$nombreServicio != null : !this$nombreServicio.equals(other$nombreServicio)) {
            return false;
        }
        String this$descripcion = this.getDescripcion();
        String other$descripcion = other.getDescripcion();
        if (this$descripcion == null ? other$descripcion != null : !this$descripcion.equals(other$descripcion)) {
            return false;
        }
        String this$ubicacionDestino = this.getUbicacionDestino();
        String other$ubicacionDestino = other.getUbicacionDestino();
        if (this$ubicacionDestino == null ? other$ubicacionDestino != null : !this$ubicacionDestino.equals(other$ubicacionDestino)) {
            return false;
        }
        String this$duracion = this.getDuracion();
        String other$duracion = other.getDuracion();
        if (this$duracion == null ? other$duracion != null : !this$duracion.equals(other$duracion)) {
            return false;
        }
        BigDecimal this$precioBase = this.getPrecioBase();
        BigDecimal other$precioBase = other.getPrecioBase();
        if (this$precioBase == null ? other$precioBase != null : !((Object)this$precioBase).equals(other$precioBase)) {
            return false;
        }
        String this$incluye = this.getIncluye();
        String other$incluye = other.getIncluye();
        if (this$incluye == null ? other$incluye != null : !this$incluye.equals(other$incluye)) {
            return false;
        }
        String this$noIncluye = this.getNoIncluye();
        String other$noIncluye = other.getNoIncluye();
        if (this$noIncluye == null ? other$noIncluye != null : !this$noIncluye.equals(other$noIncluye)) {
            return false;
        }
        String this$requisitos = this.getRequisitos();
        String other$requisitos = other.getRequisitos();
        if (this$requisitos == null ? other$requisitos != null : !this$requisitos.equals(other$requisitos)) {
            return false;
        }
        String this$politicasEspeciales = this.getPoliticasEspeciales();
        String other$politicasEspeciales = other.getPoliticasEspeciales();
        if (this$politicasEspeciales == null ? other$politicasEspeciales != null : !this$politicasEspeciales.equals(other$politicasEspeciales)) {
            return false;
        }
        String this$imagenes = this.getImagenes();
        String other$imagenes = other.getImagenes();
        if (this$imagenes == null ? other$imagenes != null : !this$imagenes.equals(other$imagenes)) {
            return false;
        }
        String this$itinerario = this.getItinerario();
        String other$itinerario = other.getItinerario();
        if (this$itinerario == null ? other$itinerario != null : !this$itinerario.equals(other$itinerario)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$deletedAt = this.getDeletedAt();
        LocalDateTime other$deletedAt = other.getDeletedAt();
        return !(this$deletedAt == null ? other$deletedAt != null : !((Object)this$deletedAt).equals(other$deletedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServicioTuristico;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $idServicio = this.getIdServicio();
        result = result * 59 + ($idServicio == null ? 43 : ((Object)$idServicio).hashCode());
        Long $idProveedor = this.getIdProveedor();
        result = result * 59 + ($idProveedor == null ? 43 : ((Object)$idProveedor).hashCode());
        Long $idCategoria = this.getIdCategoria();
        result = result * 59 + ($idCategoria == null ? 43 : ((Object)$idCategoria).hashCode());
        Integer $capacidadMaxima = this.getCapacidadMaxima();
        result = result * 59 + ($capacidadMaxima == null ? 43 : ((Object)$capacidadMaxima).hashCode());
        Boolean $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : ((Object)$estado).hashCode());
        Empresa $empresa = this.getEmpresa();
        result = result * 59 + ($empresa == null ? 43 : $empresa.hashCode());
        TipoServicio $tipoServicio = this.getTipoServicio();
        result = result * 59 + ($tipoServicio == null ? 43 : $tipoServicio.hashCode());
        String $nombreServicio = this.getNombreServicio();
        result = result * 59 + ($nombreServicio == null ? 43 : $nombreServicio.hashCode());
        String $descripcion = this.getDescripcion();
        result = result * 59 + ($descripcion == null ? 43 : $descripcion.hashCode());
        String $ubicacionDestino = this.getUbicacionDestino();
        result = result * 59 + ($ubicacionDestino == null ? 43 : $ubicacionDestino.hashCode());
        String $duracion = this.getDuracion();
        result = result * 59 + ($duracion == null ? 43 : $duracion.hashCode());
        BigDecimal $precioBase = this.getPrecioBase();
        result = result * 59 + ($precioBase == null ? 43 : ((Object)$precioBase).hashCode());
        String $incluye = this.getIncluye();
        result = result * 59 + ($incluye == null ? 43 : $incluye.hashCode());
        String $noIncluye = this.getNoIncluye();
        result = result * 59 + ($noIncluye == null ? 43 : $noIncluye.hashCode());
        String $requisitos = this.getRequisitos();
        result = result * 59 + ($requisitos == null ? 43 : $requisitos.hashCode());
        String $politicasEspeciales = this.getPoliticasEspeciales();
        result = result * 59 + ($politicasEspeciales == null ? 43 : $politicasEspeciales.hashCode());
        String $imagenes = this.getImagenes();
        result = result * 59 + ($imagenes == null ? 43 : $imagenes.hashCode());
        String $itinerario = this.getItinerario();
        result = result * 59 + ($itinerario == null ? 43 : $itinerario.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $deletedAt = this.getDeletedAt();
        result = result * 59 + ($deletedAt == null ? 43 : ((Object)$deletedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ServicioTuristico(idServicio=" + String.valueOf(this.getIdServicio()) + ", empresa=" + String.valueOf(this.getEmpresa()) + ", idProveedor=" + String.valueOf(this.getIdProveedor()) + ", idCategoria=" + String.valueOf(this.getIdCategoria()) + ", tipoServicio=" + String.valueOf(this.getTipoServicio()) + ", nombreServicio=" + this.getNombreServicio() + ", descripcion=" + this.getDescripcion() + ", ubicacionDestino=" + this.getUbicacionDestino() + ", duracion=" + this.getDuracion() + ", capacidadMaxima=" + String.valueOf(this.getCapacidadMaxima()) + ", precioBase=" + String.valueOf(this.getPrecioBase()) + ", incluye=" + this.getIncluye() + ", noIncluye=" + this.getNoIncluye() + ", requisitos=" + this.getRequisitos() + ", politicasEspeciales=" + this.getPoliticasEspeciales() + ", imagenes=" + this.getImagenes() + ", itinerario=" + this.getItinerario() + ", estado=" + String.valueOf(this.getEstado()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ", deletedAt=" + String.valueOf(this.getDeletedAt()) + ")";
    }

    @Generated
    public ServicioTuristico() {
    }
}

