/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.repository;

import com.sistema.turistico.entity.EvaluacionServicio;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EvaluacionServicioRepository
extends JpaRepository<EvaluacionServicio, Long> {
    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.reserva.idReserva = :reservaId")
    public List<EvaluacionServicio> findByReservaId(@Param(value="reservaId") Long var1);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.cliente.idCliente = :clienteId")
    public List<EvaluacionServicio> findByClienteId(@Param(value="clienteId") Long var1);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.servicio.idServicio = :servicioId")
    public List<EvaluacionServicio> findByServicioId(@Param(value="servicioId") Long var1);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.paquete.idPaquete = :paqueteId")
    public List<EvaluacionServicio> findByPaqueteId(@Param(value="paqueteId") Long var1);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.calificacionGeneral = :calificacion")
    public List<EvaluacionServicio> findByCalificacionGeneral(@Param(value="calificacion") Integer var1);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.calificacionGeneral BETWEEN :min AND :max")
    public List<EvaluacionServicio> findByCalificacionGeneralBetween(@Param(value="min") Integer var1, @Param(value="max") Integer var2);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.estado = :estado")
    public List<EvaluacionServicio> findByEstado(@Param(value="estado") Boolean var1);

    @Query(value="SELECT COUNT(e) > 0 FROM EvaluacionServicio e WHERE e.reserva.idReserva = :reservaId")
    public boolean existsByReservaId(@Param(value="reservaId") Long var1);

    @Query(value="SELECT e FROM EvaluacionServicio e WHERE e.reserva.idReserva = :reservaId")
    public Optional<EvaluacionServicio> findByReservaIdUnique(@Param(value="reservaId") Long var1);

    @Query(value="SELECT AVG(e.calificacionGeneral), COUNT(e) FROM EvaluacionServicio e WHERE e.servicio.idServicio = :servicioId AND e.estado = true")
    public Object[] getEstadisticasByServicio(@Param(value="servicioId") Long var1);

    @Query(value="SELECT AVG(e.calificacionGeneral), COUNT(e) FROM EvaluacionServicio e WHERE e.paquete.idPaquete = :paqueteId AND e.estado = true")
    public Object[] getEstadisticasByPaquete(@Param(value="paqueteId") Long var1);
}

