/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.CajaAperturaRequest;
import com.sistema.turistico.dto.CajaCierreRequest;
import com.sistema.turistico.dto.MovimientoCajaRequest;
import com.sistema.turistico.entity.Caja;
import com.sistema.turistico.entity.Empresa;
import com.sistema.turistico.entity.MovimientoCaja;
import com.sistema.turistico.entity.Sucursal;
import com.sistema.turistico.entity.Usuario;
import com.sistema.turistico.entity.Venta;
import com.sistema.turistico.repository.CajaRepository;
import com.sistema.turistico.repository.MovimientoCajaRepository;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CajaService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CajaService.class);
    private static final String MSG_CAJA_NO_ENCONTRADA = "Caja no encontrada";
    private final CajaRepository cajaRepository;
    private final MovimientoCajaRepository movimientoCajaRepository;
    @PersistenceContext
    private EntityManager entityManager;

    public Caja abrirCaja(CajaAperturaRequest request) {
        log.info("Aperturando caja para sucursal {} y usuario {}", (Object)request.getSucursalId(), (Object)request.getUsuarioAperturaId());
        if (this.cajaRepository.existsBySucursal_IdSucursalAndEstado(request.getSucursalId(), Caja.EstadoCaja.Abierta)) {
            throw new IllegalArgumentException("Ya existe una caja abierta para la sucursal seleccionada");
        }
        Caja caja = new Caja();
        caja.setEmpresa((Empresa)this.entityManager.getReference(Empresa.class, (Object)request.getEmpresaId()));
        caja.setSucursal((Sucursal)this.entityManager.getReference(Sucursal.class, (Object)request.getSucursalId()));
        caja.setUsuarioApertura((Usuario)this.entityManager.getReference(Usuario.class, (Object)request.getUsuarioAperturaId()));
        caja.setFechaApertura(LocalDate.now());
        caja.setHoraApertura(LocalTime.now());
        caja.setMontoInicial(request.getMontoInicial());
        caja.setSaldoActual(request.getMontoInicial());
        caja.setObservaciones(request.getObservaciones());
        caja.setEstado(Caja.EstadoCaja.Abierta);
        Caja cajaGuardada = (Caja)this.cajaRepository.save((Object)caja);
        log.info("Caja {} aperturada correctamente", (Object)cajaGuardada.getIdCaja());
        return cajaGuardada;
    }

    @Transactional(readOnly=true)
    public Caja obtenerCaja(Long cajaId) {
        return (Caja)this.cajaRepository.findById((Object)cajaId).orElseThrow(() -> new IllegalArgumentException(MSG_CAJA_NO_ENCONTRADA));
    }

    @Transactional(readOnly=true)
    public Caja obtenerCajaActiva(Long cajaId) {
        Caja caja = this.obtenerCaja(cajaId);
        if (!caja.estaAbierta()) {
            throw new IllegalStateException("La caja seleccionada no se encuentra abierta");
        }
        return caja;
    }

    @Transactional(readOnly=true)
    public List<Caja> listarCajasAbiertas(Long empresaId) {
        return this.cajaRepository.findByEmpresa_IdEmpresaAndEstado(empresaId, Caja.EstadoCaja.Abierta);
    }

    @Transactional(readOnly=true)
    public List<Caja> listarCajas(Long empresaId, Long sucursalId, Caja.EstadoCaja estado) {
        return this.cajaRepository.findByFilters(empresaId, sucursalId, estado);
    }

    @Transactional(readOnly=true)
    public MovimientoCaja obtenerMovimiento(Long cajaId, Long movimientoId) {
        return (MovimientoCaja)this.movimientoCajaRepository.findByIdMovimientoAndCaja_IdCaja(movimientoId, cajaId).orElseThrow(() -> new IllegalArgumentException("Movimiento no encontrado en la caja especificada"));
    }

    public Caja cerrarCaja(Long cajaId, CajaCierreRequest request) {
        log.info("Cerrando caja {} por usuario {}", (Object)cajaId, (Object)request.getUsuarioCierreId());
        Caja caja = this.obtenerCaja(cajaId);
        if (!caja.estaAbierta()) {
            throw new IllegalStateException("La caja ya se encontraba cerrada");
        }
        caja.setUsuarioCierre((Usuario)this.entityManager.getReference(Usuario.class, (Object)request.getUsuarioCierreId()));
        caja.setMontoCierre(request.getMontoCierre());
        BigDecimal diferencia = request.getMontoCierre().subtract(caja.getSaldoActual());
        caja.setDiferencia(diferencia);
        String observacion = request.getObservaciones();
        if (observacion != null && !observacion.isBlank()) {
            caja.setObservaciones(observacion);
        }
        caja.setEstado(Caja.EstadoCaja.Cerrada);
        Caja cajaCerrada = (Caja)this.cajaRepository.save((Object)caja);
        log.info("Caja {} cerrada. Diferencia registrada: {}", (Object)cajaId, (Object)diferencia);
        return cajaCerrada;
    }

    public MovimientoCaja registrarMovimiento(Long cajaId, MovimientoCajaRequest request) {
        Caja caja = this.obtenerCajaActiva(cajaId);
        MovimientoCaja movimiento = new MovimientoCaja();
        movimiento.setCaja(caja);
        movimiento.setTipoMovimiento(request.getTipoMovimiento());
        movimiento.setMonto(request.getMonto());
        movimiento.setDescripcion(request.getDescripcion());
        movimiento.setFechaHora(LocalDateTime.now());
        if (request.getVentaId() != null) {
            movimiento.setVenta((Venta)this.entityManager.getReference(Venta.class, (Object)request.getVentaId()));
        }
        BigDecimal nuevoSaldo = this.calcularNuevoSaldo(caja.getSaldoActual(), request.getTipoMovimiento(), request.getMonto());
        caja.setSaldoActual(nuevoSaldo);
        MovimientoCaja movimientoGuardado = (MovimientoCaja)this.movimientoCajaRepository.save((Object)movimiento);
        this.cajaRepository.save((Object)caja);
        log.info("Movimiento {} registrado para caja {}", (Object)movimientoGuardado.getIdMovimiento(), (Object)cajaId);
        return movimientoGuardado;
    }

    @Transactional(readOnly=true)
    public List<MovimientoCaja> obtenerMovimientos(Long cajaId, LocalDateTime inicio, LocalDateTime fin, MovimientoCaja.TipoMovimiento tipo) {
        this.obtenerCaja(cajaId);
        return this.movimientoCajaRepository.findByCajaAndFilters(cajaId, tipo, inicio, fin);
    }

    @Transactional(readOnly=true)
    public Map<String, Object> obtenerArqueo(Long cajaId, LocalDate fechaInicio, LocalDate fechaFin) {
        Caja caja = this.obtenerCaja(cajaId);
        LocalDateTime inicio = fechaInicio != null ? fechaInicio.atStartOfDay() : null;
        LocalDateTime fin = fechaFin != null ? fechaFin.atTime(LocalTime.MAX) : null;
        BigDecimal ingresos = this.movimientoCajaRepository.sumByCajaAndTipoAndRango(cajaId, MovimientoCaja.TipoMovimiento.Ingreso, inicio, fin);
        BigDecimal egresos = this.movimientoCajaRepository.sumByCajaAndTipoAndRango(cajaId, MovimientoCaja.TipoMovimiento.Egreso, inicio, fin);
        HashMap<String, Object> resumen = new HashMap<String, Object>();
        resumen.put("cajaId", cajaId);
        resumen.put("fechaApertura", caja.getFechaApertura());
        resumen.put("saldoInicial", caja.getMontoInicial());
        resumen.put("saldoActual", caja.getSaldoActual());
        resumen.put("ingresos", ingresos);
        resumen.put("egresos", egresos);
        resumen.put("saldoCalculado", caja.getMontoInicial().add(ingresos).subtract(egresos));
        return resumen;
    }

    public MovimientoCaja anularMovimiento(Long cajaId, Long movimientoId, String motivo) {
        log.info("Anulando movimiento {} de caja {}", (Object)movimientoId, (Object)cajaId);
        Caja caja = this.obtenerCajaActiva(cajaId);
        MovimientoCaja movimiento = (MovimientoCaja)this.movimientoCajaRepository.findById((Object)movimientoId).orElseThrow(() -> new IllegalArgumentException("Movimiento no encontrado"));
        if (!movimiento.getCaja().getIdCaja().equals(cajaId)) {
            throw new IllegalArgumentException("El movimiento no pertenece a la caja especificada");
        }
        if (movimiento.getVenta() != null) {
            throw new IllegalArgumentException("No se pueden anular movimientos autom\u00e1ticos generados por ventas");
        }
        MovimientoCaja movimientoReverso = new MovimientoCaja();
        movimientoReverso.setCaja(caja);
        movimientoReverso.setTipoMovimiento(MovimientoCaja.TipoMovimiento.Ingreso.equals((Object)movimiento.getTipoMovimiento()) ? MovimientoCaja.TipoMovimiento.Egreso : MovimientoCaja.TipoMovimiento.Ingreso);
        movimientoReverso.setMonto(movimiento.getMonto());
        movimientoReverso.setDescripcion("ANULACI\u00d3N: " + movimiento.getDescripcion() + (String)(motivo != null ? " - Motivo: " + motivo : ""));
        movimientoReverso.setFechaHora(LocalDateTime.now());
        BigDecimal nuevoSaldo = this.calcularNuevoSaldo(caja.getSaldoActual(), movimientoReverso.getTipoMovimiento(), movimientoReverso.getMonto());
        caja.setSaldoActual(nuevoSaldo);
        MovimientoCaja movimientoGuardado = (MovimientoCaja)this.movimientoCajaRepository.save((Object)movimientoReverso);
        this.cajaRepository.save((Object)caja);
        log.info("Movimiento {} anulado exitosamente con reverso {}", (Object)movimientoId, (Object)movimientoGuardado.getIdMovimiento());
        return movimientoGuardado;
    }

    private BigDecimal calcularNuevoSaldo(BigDecimal saldoActual, MovimientoCaja.TipoMovimiento tipo, BigDecimal monto) {
        BigDecimal resultado;
        BigDecimal bigDecimal = resultado = MovimientoCaja.TipoMovimiento.Ingreso.equals((Object)tipo) ? saldoActual.add(monto) : saldoActual.subtract(monto);
        if (resultado.compareTo(BigDecimal.ZERO) < 0) {
            throw new IllegalStateException("El saldo de caja no puede ser negativo");
        }
        return resultado;
    }

    @Generated
    public CajaService(CajaRepository cajaRepository, MovimientoCajaRepository movimientoCajaRepository) {
        this.cajaRepository = cajaRepository;
        this.movimientoCajaRepository = movimientoCajaRepository;
    }
}

