/*
 * Decompiled with CFR 0.152.
 */
package com.sistema.turistico.service;

import com.sistema.turistico.dto.ClienteResponse;
import com.sistema.turistico.entity.Cliente;
import com.sistema.turistico.repository.ClienteRepository;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ClienteService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClienteService.class);
    private final ClienteRepository clienteRepository;

    public Cliente create(Cliente cliente) {
        log.info("Creando nuevo cliente: {} {}", (Object)cliente.getNombre(), (Object)cliente.getApellido());
        if (cliente.getEmail() != null && !cliente.getEmail().trim().isEmpty() && this.clienteRepository.existsByEmpresaIdAndEmailAndIdNot(cliente.getEmpresa().getIdEmpresa(), cliente.getEmail(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe un cliente con este email en la empresa");
        }
        if (cliente.getDni() != null && !cliente.getDni().trim().isEmpty() && this.clienteRepository.existsByEmpresaIdAndDniAndIdNot(cliente.getEmpresa().getIdEmpresa(), cliente.getDni(), Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe un cliente con este DNI en la empresa");
        }
        if (cliente.getEmail() != null) {
            cliente.setEmailEncriptado(cliente.getEmail().getBytes());
        }
        if (cliente.getTelefono() != null) {
            cliente.setTelefonoEncriptado(cliente.getTelefono().getBytes());
        }
        cliente.setEstado(Boolean.valueOf(true));
        Cliente savedCliente = (Cliente)this.clienteRepository.save((Object)cliente);
        log.info("Cliente creado exitosamente con ID: {}", (Object)savedCliente.getIdCliente());
        return savedCliente;
    }

    @Transactional(readOnly=true)
    public Optional<Cliente> findById(Long id) {
        log.debug("Buscando cliente con ID: {}", (Object)id);
        return this.clienteRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public List<Cliente> findByEmpresaId(Long empresaId) {
        log.debug("Listando clientes de empresa ID: {}", (Object)empresaId);
        return this.clienteRepository.findByEmpresaId(empresaId);
    }

    @Transactional(readOnly=true)
    public List<Cliente> findByEmpresaIdAndBusqueda(Long empresaId, String busqueda) {
        log.debug("Buscando clientes en empresa {} con t\u00e9rmino: {}", (Object)empresaId, (Object)busqueda);
        if (busqueda == null || busqueda.trim().isEmpty()) {
            return this.clienteRepository.findByEmpresaIdOrderByCreatedAtDesc(empresaId);
        }
        return this.clienteRepository.findByEmpresaIdAndBusqueda(empresaId, busqueda.trim());
    }

    public Cliente update(Long id, Cliente clienteActualizado) {
        log.info("Actualizando cliente ID: {}", (Object)id);
        Cliente clienteExistente = (Cliente)this.clienteRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
        if (clienteActualizado.getEmail() != null && !clienteActualizado.getEmail().trim().isEmpty() && this.clienteRepository.existsByEmpresaIdAndEmailAndIdNot(clienteExistente.getEmpresa().getIdEmpresa(), clienteActualizado.getEmail(), id)) {
            throw new IllegalArgumentException("Ya existe un cliente con este email en la empresa");
        }
        if (clienteActualizado.getDni() != null && !clienteActualizado.getDni().trim().isEmpty() && this.clienteRepository.existsByEmpresaIdAndDniAndIdNot(clienteExistente.getEmpresa().getIdEmpresa(), clienteActualizado.getDni(), id)) {
            throw new IllegalArgumentException("Ya existe un cliente con este DNI en la empresa");
        }
        clienteExistente.setNombre(clienteActualizado.getNombre());
        clienteExistente.setApellido(clienteActualizado.getApellido());
        clienteExistente.setEmail(clienteActualizado.getEmail());
        clienteExistente.setTelefono(clienteActualizado.getTelefono());
        clienteExistente.setDni(clienteActualizado.getDni());
        clienteExistente.setFechaNacimiento(clienteActualizado.getFechaNacimiento());
        clienteExistente.setNacionalidad(clienteActualizado.getNacionalidad());
        clienteExistente.setPreferenciasViaje(clienteActualizado.getPreferenciasViaje());
        clienteExistente.setNivelMembresia(clienteActualizado.getNivelMembresia());
        if (clienteActualizado.getEmail() != null) {
            clienteExistente.setEmailEncriptado(clienteActualizado.getEmail().getBytes());
        }
        if (clienteActualizado.getTelefono() != null) {
            clienteExistente.setTelefonoEncriptado(clienteActualizado.getTelefono().getBytes());
        }
        Cliente updatedCliente = (Cliente)this.clienteRepository.save((Object)clienteExistente);
        log.info("Cliente actualizado exitosamente: {}", (Object)updatedCliente.getIdCliente());
        return updatedCliente;
    }

    public void delete(Long id) {
        log.info("Eliminando cliente ID: {} (soft delete)", (Object)id);
        Cliente cliente = (Cliente)this.clienteRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Cliente no encontrado"));
        cliente.setEstado(Boolean.valueOf(false));
        cliente.setDeletedAt(LocalDateTime.now());
        this.clienteRepository.save((Object)cliente);
        log.info("Cliente eliminado exitosamente: {}", (Object)id);
    }

    @Transactional(readOnly=true)
    public boolean existsByEmpresaAndEmail(Long empresaId, String email) {
        return this.clienteRepository.existsByEmpresaIdAndEmailAndIdNot(empresaId, email, Long.valueOf(0L));
    }

    @Transactional(readOnly=true)
    public boolean existsByEmpresaAndDni(Long empresaId, String dni) {
        return this.clienteRepository.existsByEmpresaIdAndDniAndIdNot(empresaId, dni, Long.valueOf(0L));
    }

    @Transactional(readOnly=true)
    public Long countByEmpresaId(Long empresaId) {
        return this.clienteRepository.countByEmpresaId(empresaId);
    }

    public ClienteResponse toResponse(Cliente cliente) {
        return new ClienteResponse(cliente.getIdCliente(), cliente.getNombre(), cliente.getApellido(), cliente.getEmail(), cliente.getTelefono(), cliente.getDni(), cliente.getFechaNacimiento() != null ? cliente.getFechaNacimiento().toLocalDate() : null, cliente.getNacionalidad(), cliente.getPreferenciasViaje(), cliente.getEstado().booleanValue(), cliente.getCreatedAt() != null ? cliente.getCreatedAt().toString() : null, cliente.getUpdatedAt() != null ? cliente.getUpdatedAt().toString() : null);
    }

    @Generated
    public ClienteService(ClienteRepository clienteRepository) {
        this.clienteRepository = clienteRepository;
    }
}

